/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.IEventListener;

public class ListenerList {
    private static ArrayList allLists = new ArrayList();
    private static int maxSize = 0;
    private ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        allLists.add(this);
        this.resizeLists(maxSize);
    }

    public ListenerList(ListenerList parent) {
        allLists.add(this);
        this.parent = parent;
        this.resizeLists(maxSize);
    }

    public static void resize(int max) {
        if (max <= maxSize) {
            return;
        }
        for (ListenerList list : allLists) {
            list.resizeLists(max);
        }
        maxSize = max;
    }

    public void resizeLists(int max) {
        int x2;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x2 = 0; x2 < this.lists.length; ++x2) {
            newList[x2] = this.lists[x2];
        }
        while (x2 < max) {
            newList[x2] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x2)) : new ListenerListInst();
            ++x2;
        }
        this.lists = newList;
    }

    public static void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static void unregiterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }

    private class ListenerListInst {
        private boolean rebuild = true;
        private IEventListener[] listeners;
        private ArrayList priorities;
        private ListenerListInst parent;

        private ListenerListInst() {
            int count = EventPriority.values().length;
            this.priorities = new ArrayList(count);
            for (int x2 = 0; x2 < count; ++x2) {
                this.priorities.add(new ArrayList());
            }
        }

        public void dispose() {
            for (ArrayList listeners : this.priorities) {
                listeners.clear();
            }
            this.priorities.clear();
            this.parent = null;
            this.listeners = null;
        }

        private ListenerListInst(ListenerListInst parent) {
            this();
            this.parent = parent;
        }

        public ArrayList getListeners(EventPriority priority) {
            ArrayList ret = new ArrayList((Collection)this.priorities.get(priority.ordinal()));
            if (this.parent != null) {
                ret.addAll(this.parent.getListeners(priority));
            }
            return ret;
        }

        public IEventListener[] getListeners() {
            if (this.shouldRebuild()) {
                this.buildCache();
            }
            return this.listeners;
        }

        protected boolean shouldRebuild() {
            return this.rebuild || this.parent != null && this.parent.shouldRebuild();
        }

        private void buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList ret = new ArrayList();
            for (EventPriority value : EventPriority.values()) {
                ret.addAll(this.getListeners(value));
            }
            this.listeners = ret.toArray(new IEventListener[ret.size()]);
            this.rebuild = false;
        }

        public void register(EventPriority priority, IEventListener listener) {
            ((ArrayList)this.priorities.get(priority.ordinal())).add(listener);
            this.rebuild = true;
        }

        public void unregister(IEventListener listener) {
            for (ArrayList list : this.priorities) {
                list.remove(listener);
            }
        }
    }
}

