/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.util.property.simple;

import eu.ha3.util.property.contract.ConfigSource;
import eu.ha3.util.property.contract.PropertyHolder;
import eu.ha3.util.property.contract.Versionnable;
import eu.ha3.util.property.simple.VersionnableProperty;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ConfigProperty
implements PropertyHolder,
Versionnable,
ConfigSource {
    private VersionnableProperty mixed = new VersionnableProperty();
    private String path;

    @Override
    public void setSource(String path) {
        this.path = path;
    }

    @Override
    public boolean load() {
        File file = new File(this.path);
        if (file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                Properties props = new Properties();
                props.load(reader);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    this.mixed.setProperty(entry.getKey().toString(), entry.getValue().toString());
                }
                this.mixed.commit();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
                this.mixed.revert();
                return false;
            }
            catch (IOException e3) {
                e3.printStackTrace();
                this.mixed.revert();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean save() {
        try {
            File userFile = new File(this.path);
            Properties props = new Properties();
            for (Map.Entry property : this.mixed.getAllProperties().entrySet()) {
                props.setProperty((String)property.getKey(), (String)property.getValue());
            }
            props.store(new FileWriter(userFile), "");
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean commit() {
        return this.mixed.commit();
    }

    @Override
    public void revert() {
        this.mixed.revert();
    }

    @Override
    public String getString(String name) {
        return this.mixed.getString(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.mixed.getBoolean(name);
    }

    @Override
    public int getInteger(String name) {
        return this.mixed.getInteger(name);
    }

    @Override
    public float getFloat(String name) {
        return this.mixed.getFloat(name);
    }

    @Override
    public long getLong(String name) {
        return this.mixed.getLong(name);
    }

    @Override
    public double getDouble(String name) {
        return this.mixed.getDouble(name);
    }

    @Override
    public void setProperty(String name, Object o2) {
        this.mixed.setProperty(name, o2);
    }

    @Override
    public Map getAllProperties() {
        return this.mixed.getAllProperties();
    }
}

