/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Condition;
import eu.ha3.matmos.engine.ConditionSet;
import eu.ha3.matmos.engine.Descriptible;
import eu.ha3.matmos.engine.Dynamic;
import eu.ha3.matmos.engine.Event;
import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.MAtmosException;
import eu.ha3.matmos.engine.Machine;
import eu.ha3.matmos.engine.Stream;
import eu.ha3.matmos.engine.SugarList;
import eu.ha3.matmos.engine.TimedEvent;
import javax.xml.xpath.XPathExpressionException;
import net.sf.practicalxml.DomUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UtilityLoader {
    Knowledge knowledgeWorkstation;
    static final String NAME = "name";
    static final String DESCRIPTIBLE = "descriptible";
    static final String NICKNAME = "nickname";
    static final String DESCRIPTION = "description";
    static final String ICON = "icon";
    static final String META = "meta";
    static final String LIST = "list";
    static final String CONDITION = "condition";
    static final String SHEET = "sheet";
    static final String KEY = "key";
    static final String DYNAMICKEY = "dynamickey";
    static final String SYMBOL = "symbol";
    static final String CONSTANT = "constant";
    static final String SET = "set";
    static final String TRUEPART = "truepart";
    static final String FALSEPART = "falsepart";
    static final String EVENT = "event";
    static final String VOLMIN = "volmin";
    static final String VOLMAX = "volmax";
    static final String PITCHMIN = "pitchmin";
    static final String PITCHMAX = "pitchmax";
    static final String METASOUND = "metasound";
    static final String PATH = "path";
    static final String MACHINE = "machine";
    static final String ALLOW = "allow";
    static final String RESTRICT = "restrict";
    static final String DYNAMIC = "dynamic";
    static final String ENTRY = "entry";
    static final String EVENTTIMED = "eventtimed";
    static final String EVENTNAME = "eventname";
    static final String VOLMOD = "volmod";
    static final String PITCHMOD = "pitchmod";
    static final String DELAYSTART = "delaystart";
    static final String DELAYMIN = "delaymin";
    static final String DELAYMAX = "delaymax";
    static final String STREAM = "stream";
    static final String VOLUME = "volume";
    static final String PITCH = "pitch";
    static final String FADEINTIME = "fadeintime";
    static final String FADEOUTTIME = "fadeouttime";
    static final String DELAYBEFOREFADEIN = "delaybeforefadein";
    static final String DELAYBEFOREFADEOUT = "delaybeforefadeout";
    static final String ISLOOPING = "islooping";
    static final String ISUSINGPAUSE = "isusingpause";

    private UtilityLoader() {
    }

    public static UtilityLoader getInstance() {
        return MAtmosUtilityLoaderSingletonHolder.instance;
    }

    public boolean loadKnowledge(Knowledge original, Document doc, boolean allowOverrides) throws MAtmosException {
        try {
            this.parseXML(original, doc, allowOverrides);
            return true;
        }
        catch (XPathExpressionException e2) {
            e2.printStackTrace();
            return false;
        }
        catch (NumberFormatException e3) {
            e3.printStackTrace();
            return false;
        }
    }

    private int toInt(String source) {
        try {
            return Integer.parseInt(source);
        }
        catch (NumberFormatException e2) {
            return (int)Float.parseFloat(source);
        }
    }

    private void extractXMLdescriptible(Knowledge original, Element capsule, Descriptible descriptible) throws XPathExpressionException {
        Element descElt = DomUtil.getChild(capsule, DESCRIPTIBLE);
        if (descElt != null) {
            this.parseXMLdescriptible(original, descElt, descriptible);
        }
    }

    private void parseXMLdescriptible(Knowledge original, Element descNode, Descriptible descriptible) throws XPathExpressionException {
        if (descNode == null) {
            return;
        }
        String nickname = this.eltString(NICKNAME, descNode);
        String description = this.eltString(DESCRIPTION, descNode);
        String icon = this.eltString(ICON, descNode);
        String meta = this.eltString(META, descNode);
        if (nickname != null) {
            descriptible.nickname = nickname;
        }
        if (description != null) {
            descriptible.description = description;
        }
        if (icon != null) {
            descriptible.icon = icon;
        }
        if (meta != null) {
            descriptible.meta = meta;
        }
    }

    private void parseXMLdynamic(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        boolean exists;
        boolean bl = exists = original.getDynamic(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addDynamic(name);
        }
        Dynamic descriptible = original.getDynamic(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        for (Element eelt : DomUtil.getChildren(capsule, ENTRY)) {
            Node nameNode = eelt.getAttributes().getNamedItem(SHEET);
            if (nameNode == null) continue;
            descriptible.addCouple(nameNode.getNodeValue(), Integer.parseInt(eelt.getTextContent()));
        }
    }

    private void parseXMLlist(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        boolean exists;
        boolean bl = exists = original.getList(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addList(name);
        }
        SugarList descriptible = original.getList(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        for (Element eelt : DomUtil.getChildren(capsule, CONSTANT)) {
            String constant = this.textOf(eelt);
            descriptible.add(this.toInt(constant));
        }
    }

    private void parseXMLcondition(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        boolean exists;
        boolean bl = exists = original.getCondition(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addCondition(name);
        }
        Condition descriptible = original.getCondition(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        String sheet = this.eltString(SHEET, capsule);
        String key = this.eltString(KEY, capsule);
        String dynamickey = this.eltString(DYNAMICKEY, capsule);
        String symbol = this.eltString(SYMBOL, capsule);
        String constant = this.eltString(CONSTANT, capsule);
        String list = this.eltString(LIST, capsule);
        if (sheet != null) {
            descriptible.setSheet(sheet);
        }
        if (key != null) {
            descriptible.setKey(this.toInt(key));
        }
        if (dynamickey != null && !dynamickey.equals("")) {
            descriptible.setDynamic(dynamickey);
        }
        if (symbol != null) {
            descriptible.setSymbol(symbol);
        }
        if (constant != null) {
            descriptible.setConstant(this.toInt(constant));
        }
        if (list != null) {
            descriptible.setList(list);
        }
    }

    private void parseXMLset(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        boolean exists;
        boolean bl = exists = original.getConditionSet(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addConditionSet(name);
        }
        ConditionSet descriptible = original.getConditionSet(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        for (Element eelt : DomUtil.getChildren(capsule, TRUEPART)) {
            String truepart = this.textOf(eelt);
            descriptible.addCondition(truepart, true);
        }
        for (Element eelt : DomUtil.getChildren(capsule, FALSEPART)) {
            String falsepart = this.textOf(eelt);
            descriptible.addCondition(falsepart, false);
        }
    }

    private void parseXMLevent(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        boolean exists;
        boolean bl = exists = original.getEvent(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addEvent(name);
        }
        Event descriptible = original.getEvent(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        String volmin = this.eltString(VOLMIN, capsule);
        String volmax = this.eltString(VOLMAX, capsule);
        String pitchmin = this.eltString(PITCHMIN, capsule);
        String pitchmax = this.eltString(PITCHMAX, capsule);
        String metasound = this.eltString(METASOUND, capsule);
        if (volmin != null) {
            descriptible.volMin = Float.parseFloat(volmin);
        }
        if (volmax != null) {
            descriptible.volMax = Float.parseFloat(volmax);
        }
        if (pitchmin != null) {
            descriptible.pitchMin = Float.parseFloat(pitchmin);
        }
        if (pitchmax != null) {
            descriptible.pitchMax = Float.parseFloat(pitchmax);
        }
        if (metasound != null) {
            descriptible.metaSound = this.toInt(metasound);
        }
        for (Element eelt : DomUtil.getChildren(capsule, PATH)) {
            String path = this.textOf(eelt);
            descriptible.paths.add(path);
        }
    }

    private void parseXMLmachine(Knowledge original, Element capsule, String name, boolean allowOverrides) throws XPathExpressionException {
        int size;
        boolean exists;
        boolean bl = exists = original.getMachine(name) != null;
        if (exists && !allowOverrides) {
            return;
        }
        if (!exists) {
            original.addMachine(name);
        }
        Machine descriptible = original.getMachine(name);
        this.extractXMLdescriptible(original, capsule, descriptible);
        for (Element eelt : DomUtil.getChildren(capsule, EVENTTIMED)) {
            size = descriptible.addEventTimed();
            this.inscriptXMLeventTimed(descriptible.getEventTimed(size - 1), eelt);
        }
        for (Element eelt : DomUtil.getChildren(capsule, STREAM)) {
            size = descriptible.addStream();
            this.inscriptXMLstream(descriptible.getStream(size - 1), eelt);
        }
        for (Element eelt : DomUtil.getChildren(capsule, ALLOW)) {
            descriptible.addAllow(this.textOf(eelt));
        }
        for (Element eelt : DomUtil.getChildren(capsule, RESTRICT)) {
            descriptible.addRestrict(this.textOf(eelt));
        }
    }

    private void inscriptXMLeventTimed(TimedEvent inscriptible, Element specs) throws XPathExpressionException {
        String eventname = this.eltString(EVENTNAME, specs);
        String volmod = this.eltString(VOLMOD, specs);
        String pitchmod = this.eltString(PITCHMOD, specs);
        String delaystart = this.eltString(DELAYSTART, specs);
        String delaymin = this.eltString(DELAYMIN, specs);
        String delaymax = this.eltString(DELAYMAX, specs);
        if (eventname != null) {
            inscriptible.event = eventname;
        }
        if (volmod != null) {
            inscriptible.volMod = Float.parseFloat(volmod);
        }
        if (pitchmod != null) {
            inscriptible.pitchMod = Float.parseFloat(pitchmod);
        }
        if (delaystart != null) {
            inscriptible.delayStart = Float.parseFloat(delaystart);
        }
        if (delaymin != null) {
            inscriptible.delayMin = Float.parseFloat(delaymin);
        }
        if (delaymax != null) {
            inscriptible.delayMax = Float.parseFloat(delaymax);
        }
    }

    private void inscriptXMLstream(Stream inscriptible, Element specs) throws XPathExpressionException {
        String _PATH = this.eltString(PATH, specs);
        String _VOLUME = this.eltString(VOLUME, specs);
        String _PITCH = this.eltString(PITCH, specs);
        String _FADEINTIME = this.eltString(FADEINTIME, specs);
        String _FADEOUTTIME = this.eltString(FADEOUTTIME, specs);
        String _DELAYBEFOREFADEIN = this.eltString(DELAYBEFOREFADEIN, specs);
        String _DELAYBEFOREFADEOUT = this.eltString(DELAYBEFOREFADEOUT, specs);
        String _ISLOOPING = this.eltString(ISLOOPING, specs);
        String _ISUSINGPAUSE = this.eltString(ISUSINGPAUSE, specs);
        if (_PATH != null) {
            inscriptible.path = _PATH;
        }
        if (_VOLUME != null) {
            inscriptible.volume = Float.parseFloat(_VOLUME);
        }
        if (_PITCH != null) {
            inscriptible.pitch = Float.parseFloat(_PITCH);
        }
        if (_FADEINTIME != null) {
            inscriptible.fadeInTime = Float.parseFloat(_FADEINTIME);
        }
        if (_FADEOUTTIME != null) {
            inscriptible.fadeOutTime = Float.parseFloat(_FADEOUTTIME);
        }
        if (_DELAYBEFOREFADEIN != null) {
            inscriptible.delayBeforeFadeIn = Float.parseFloat(_DELAYBEFOREFADEIN);
        }
        if (_DELAYBEFOREFADEOUT != null) {
            inscriptible.delayBeforeFadeOut = Float.parseFloat(_DELAYBEFOREFADEOUT);
        }
        if (_ISLOOPING != null) {
            boolean bl = inscriptible.isLooping = this.toInt(_ISLOOPING) == 1;
        }
        if (_ISUSINGPAUSE != null) {
            inscriptible.isUsingPause = this.toInt(_ISUSINGPAUSE) == 1;
        }
    }

    private void parseXML(Knowledge original, Document doc, boolean allowOverrides) throws XPathExpressionException, DOMException {
        Node nameNode;
        Element capsule;
        int i2;
        Element elt = doc.getDocumentElement();
        DomUtil.removeEmptyTextRecursive(elt);
        NodeList cat = elt.getElementsByTagName(DYNAMIC);
        for (i2 = 0; i2 < cat.getLength(); ++i2) {
            capsule = (Element)cat.item(i2);
            nameNode = capsule.getAttributes().getNamedItem(NAME);
            if (nameNode == null) continue;
            this.parseXMLdynamic(original, capsule, nameNode.getNodeValue(), allowOverrides);
        }
        cat = elt.getElementsByTagName(LIST);
        for (i2 = 0; i2 < cat.getLength(); ++i2) {
            capsule = (Element)cat.item(i2);
            nameNode = capsule.getAttributes().getNamedItem(NAME);
            if (nameNode == null) continue;
            this.parseXMLlist(original, capsule, nameNode.getNodeValue(), allowOverrides);
        }
        for (Element capsule2 : DomUtil.getChildren(elt, CONDITION)) {
            Node nameNode2 = capsule2.getAttributes().getNamedItem(NAME);
            if (nameNode2 == null) continue;
            this.parseXMLcondition(original, capsule2, nameNode2.getNodeValue(), allowOverrides);
        }
        cat = elt.getElementsByTagName(SET);
        for (i2 = 0; i2 < cat.getLength(); ++i2) {
            capsule = (Element)cat.item(i2);
            nameNode = capsule.getAttributes().getNamedItem(NAME);
            if (nameNode == null) continue;
            this.parseXMLset(original, capsule, nameNode.getNodeValue(), allowOverrides);
        }
        cat = elt.getElementsByTagName(EVENT);
        for (i2 = 0; i2 < cat.getLength(); ++i2) {
            capsule = (Element)cat.item(i2);
            nameNode = capsule.getAttributes().getNamedItem(NAME);
            if (nameNode == null) continue;
            this.parseXMLevent(original, capsule, nameNode.getNodeValue(), allowOverrides);
        }
        cat = elt.getElementsByTagName(MACHINE);
        for (i2 = 0; i2 < cat.getLength(); ++i2) {
            capsule = (Element)cat.item(i2);
            nameNode = capsule.getAttributes().getNamedItem(NAME);
            if (nameNode == null) continue;
            this.parseXMLmachine(original, capsule, nameNode.getNodeValue(), allowOverrides);
        }
    }

    private String eltString(String tagName, Element ele) {
        return this.textOf(DomUtil.getChild(ele, tagName));
    }

    private String textOf(Element ele) {
        if (ele == null || ele.getFirstChild() == null) {
            return null;
        }
        return ele.getFirstChild().getNodeValue();
    }

    private static class MAtmosUtilityLoaderSingletonHolder {
        public static final UtilityLoader instance = new UtilityLoader();

        private MAtmosUtilityLoaderSingletonHolder() {
        }
    }
}

