/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Descriptible;
import eu.ha3.matmos.engine.Event;
import eu.ha3.matmos.engine.Machine;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.DTD;

public class TimedEvent
extends Descriptible {
    Machine machine;
    public String event = "";
    public float volMod;
    public float pitchMod;
    public float delayMin;
    public float delayMax;
    public float delayStart;
    public long nextPlayTime;

    TimedEvent(Machine machineIn) {
        this.machine = machineIn;
        this.volMod = 1.0f;
        this.pitchMod = 1.0f;
        this.delayMin = 10.0f;
        this.delayMax = 10.0f;
        this.delayStart = 0.0f;
    }

    void setMachine(Machine machineIn) {
        this.machine = machineIn;
    }

    public void routine() {
        if (this.machine.knowledge.getTimeMillis() < this.nextPlayTime) {
            return;
        }
        if (this.machine.knowledge.events.containsKey(this.event)) {
            ((Event)this.machine.knowledge.events.get(this.event)).playSound(this.volMod, this.pitchMod);
        }
        if (this.delayMin == this.delayMax && this.delayMin > 0.0f) {
            while (this.nextPlayTime < this.machine.knowledge.getTimeMillis()) {
                this.nextPlayTime += (long)(this.delayMin * 1000.0f);
            }
        } else {
            this.nextPlayTime = this.machine.knowledge.getTimeMillis() + (long)((this.delayMin + this.machine.knowledge.random.nextFloat() * (this.delayMax - this.delayMin)) * 1000.0f);
        }
    }

    public void restart() {
        this.nextPlayTime = this.delayStart == 0.0f ? this.machine.knowledge.getTimeMillis() + (long)(this.machine.knowledge.random.nextFloat() * this.delayMax * 1000.0f) : this.machine.knowledge.getTimeMillis() + (long)(this.delayStart * 1000.0f);
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        DTD ret = eventFactory.createDTD("\n");
        DTD tab = eventFactory.createDTD("\t");
        eventWriter.add(tab);
        eventWriter.add(eventFactory.createStartElement("", "", "eventtimed"));
        eventWriter.add(ret);
        this.createNode(eventWriter, "eventname", this.event, 2);
        this.createNode(eventWriter, "delaymin", "" + this.delayMin, 2);
        this.createNode(eventWriter, "delaymax", "" + this.delayMax, 2);
        this.createNode(eventWriter, "delaystart", "" + this.delayStart, 2);
        this.createNode(eventWriter, "volmod", "" + this.volMod, 2);
        this.createNode(eventWriter, "pitchmod", "" + this.pitchMod, 2);
        eventWriter.add(tab);
        eventWriter.add(eventFactory.createEndElement("", "", "eventtimed"));
        eventWriter.add(ret);
        return "";
    }
}

