/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.ConditionSet;
import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.MAtmosLogger;
import eu.ha3.matmos.engine.Stream;
import eu.ha3.matmos.engine.Switchable;
import eu.ha3.matmos.engine.TimedEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class Machine
extends Switchable {
    private List anyallows;
    private List anyrestricts;
    private List etimes = new ArrayList();
    private List streams = new ArrayList();
    private boolean powered = false;
    private boolean switchedOn = false;

    Machine(Knowledge knowledgeIn) {
        super(knowledgeIn);
        this.anyallows = new ArrayList();
        this.anyrestricts = new ArrayList();
    }

    public void routine() {
        if (this.switchedOn) {
            for (TimedEvent etime : this.etimes) {
                etime.routine();
            }
        }
        if (this.powered && !this.streams.isEmpty()) {
            Iterator iter = this.streams.iterator();
            while (iter.hasNext()) {
                ((Stream)iter.next()).routine();
            }
        }
    }

    public void turnOn() {
        if (!this.powered) {
            return;
        }
        if (this.switchedOn) {
            return;
        }
        this.switchedOn = true;
        Iterator iter = this.etimes.iterator();
        while (iter.hasNext()) {
            ((TimedEvent)iter.next()).restart();
        }
        iter = this.streams.iterator();
        while (iter.hasNext()) {
            ((Stream)iter.next()).signalPlayable();
        }
    }

    public void turnOff() {
        if (!this.powered) {
            return;
        }
        if (!this.switchedOn) {
            return;
        }
        this.switchedOn = false;
        Iterator iter = this.streams.iterator();
        while (iter.hasNext()) {
            ((Stream)iter.next()).signalStoppable();
        }
    }

    public void powerOn() {
        this.powered = true;
    }

    public void powerOff() {
        Iterator iter = this.streams.iterator();
        while (iter.hasNext()) {
            ((Stream)iter.next()).clearToken();
        }
        this.turnOff();
        this.powered = false;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isOn() {
        return this.switchedOn;
    }

    public List getAllows() {
        return this.anyallows;
    }

    public List getRestricts() {
        return this.anyrestricts;
    }

    public void addAllow(String name) {
        this.anyallows.add(name);
        this.flagNeedsTesting();
    }

    public void addRestrict(String name) {
        this.anyrestricts.add(name);
        this.flagNeedsTesting();
    }

    public void removeSet(String name) {
        this.anyallows.remove(name);
        this.anyrestricts.remove(name);
        this.flagNeedsTesting();
    }

    public void replaceSetName(String name, String newName) {
        if (this.anyallows.contains(name)) {
            this.anyallows.add(newName);
            this.anyallows.remove(name);
        }
        if (this.anyrestricts.contains(name)) {
            this.anyrestricts.add(newName);
            this.anyrestricts.remove(name);
        }
        this.flagNeedsTesting();
    }

    public List getEventsTimed() {
        return this.etimes;
    }

    public int addEventTimed() {
        this.etimes.add(new TimedEvent(this));
        return this.etimes.size();
    }

    public int removeEventTimed(int index) {
        this.etimes.remove(index);
        return this.etimes.size();
    }

    public TimedEvent getEventTimed(int index) {
        return (TimedEvent)this.etimes.get(index);
    }

    public List getStreams() {
        return this.streams;
    }

    public int addStream() {
        this.streams.add(new Stream(this));
        return this.streams.size();
    }

    public int removeStream(int index) {
        this.streams.remove(index);
        return this.streams.size();
    }

    public Stream getStream(int index) {
        return (Stream)this.streams.get(index);
    }

    @Override
    protected boolean testIfValid() {
        if (this.anyallows.size() == 0) {
            return false;
        }
        for (String cset : this.anyallows) {
            if (this.knowledge.sets.containsKey(cset)) continue;
            return false;
        }
        for (String cset : this.anyrestricts) {
            if (this.knowledge.sets.containsKey(cset)) continue;
            return false;
        }
        return true;
    }

    public boolean evaluate() {
        if (!this.isValid()) {
            return false;
        }
        if (!this.powered) {
            return false;
        }
        boolean pre = this.switchedOn;
        boolean shallBeOn = this.testIfTrue();
        if (pre != shallBeOn) {
            if (shallBeOn) {
                this.turnOn();
            } else {
                this.turnOff();
            }
            MAtmosLogger.LOGGER.fine("M:" + this.nickname + (this.switchedOn ? " now On." : " now Off."));
        }
        return this.switchedOn;
    }

    @Override
    public boolean isActive() {
        return this.isTrue();
    }

    public boolean isTrue() {
        return this.switchedOn;
    }

    public boolean testIfTrue() {
        if (!this.isValid()) {
            return false;
        }
        boolean isTrue = false;
        Iterator iterAnyallows = this.anyallows.iterator();
        while (!isTrue && iterAnyallows.hasNext()) {
            String cset = (String)iterAnyallows.next();
            if (!((ConditionSet)this.knowledge.sets.get(cset)).isTrue()) continue;
            isTrue = true;
        }
        Iterator iterAnyrestricts = this.anyrestricts.iterator();
        while (isTrue && iterAnyrestricts.hasNext()) {
            String cset = (String)iterAnyrestricts.next();
            if (!((ConditionSet)this.knowledge.sets.get(cset)).isTrue()) continue;
            isTrue = false;
        }
        return isTrue;
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        this.buildDescriptibleSerialized(eventWriter);
        Iterator iter = this.anyallows.iterator();
        while (iter.hasNext()) {
            this.createNode(eventWriter, "allow", (String)iter.next());
        }
        iter = this.anyrestricts.iterator();
        while (iter.hasNext()) {
            this.createNode(eventWriter, "restrict", (String)iter.next());
        }
        iter = this.etimes.iterator();
        while (iter.hasNext()) {
            ((TimedEvent)iter.next()).serialize(eventWriter);
        }
        iter = this.streams.iterator();
        while (iter.hasNext()) {
            ((Stream)iter.next()).serialize(eventWriter);
        }
        return "";
    }

    public List getTimedEvents() {
        return this.etimes;
    }
}

