/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Condition;
import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.MAtmosLogger;
import eu.ha3.matmos.engine.Switchable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class ConditionSet
extends Switchable {
    private Map conditions = new LinkedHashMap();
    private boolean isTrueEvaluated = false;

    public ConditionSet(Knowledge knowledgeIn) {
        super(knowledgeIn);
    }

    @Override
    protected boolean testIfValid() {
        if (this.conditions.size() == 0) {
            return false;
        }
        for (String condition : this.conditions.keySet()) {
            if (this.knowledge.conditions.containsKey(condition)) continue;
            return false;
        }
        return true;
    }

    public void replaceConditionName(String name, String newName) {
        this.flagNeedsTesting();
        if (this.conditions.containsKey(name)) {
            this.conditions.put(newName, this.conditions.get(name));
            this.conditions.remove(name);
        }
    }

    public void setSet(Object ... args) throws IllegalArgumentException {
        this.flagNeedsTesting();
        if (args.length % 2 == 0) {
            this.conditions.clear();
            for (int i2 = 0; i2 < args.length / 2; ++i2) {
                this.conditions.put((String)args[i2], (Boolean)args[i2 + 1]);
            }
        } else {
            this.conditions.clear();
            throw new IllegalArgumentException();
        }
    }

    public void addCondition(String name, boolean truth) throws IllegalArgumentException {
        this.flagNeedsTesting();
        this.conditions.put(name, truth);
    }

    public void removeCondition(String name) {
        this.flagNeedsTesting();
        this.conditions.remove(name);
    }

    public Map getSet() {
        return this.conditions;
    }

    public boolean evaluate() {
        if (!this.isValid()) {
            return false;
        }
        boolean pre = this.isTrueEvaluated;
        this.isTrueEvaluated = this.testIfTrue();
        if (pre != this.isTrueEvaluated) {
            MAtmosLogger.LOGGER.finer("S:" + this.nickname + (this.isTrueEvaluated ? " now On." : " now Off."));
        }
        return this.isTrueEvaluated;
    }

    @Override
    public boolean isActive() {
        return this.isTrue();
    }

    public boolean isTrue() {
        return this.isTrueEvaluated;
    }

    public boolean testIfTrue() {
        if (!this.isValid()) {
            return false;
        }
        boolean isTrue = true;
        Iterator iterConditions = this.conditions.entrySet().iterator();
        while (isTrue && iterConditions.hasNext()) {
            Map.Entry condition = iterConditions.next();
            if (((Boolean)condition.getValue()).booleanValue() == ((Condition)this.knowledge.conditions.get(condition.getKey())).isTrue()) continue;
            isTrue = false;
        }
        return isTrue;
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        this.buildDescriptibleSerialized(eventWriter);
        for (Map.Entry struct : this.conditions.entrySet()) {
            if (((Boolean)struct.getValue()).booleanValue()) {
                this.createNode(eventWriter, "truepart", (String)struct.getKey());
                continue;
            }
            this.createNode(eventWriter, "falsepart", (String)struct.getKey());
        }
        return "";
    }
}

