/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.matmos.engine;

import eu.ha3.matmos.engine.Dynamic;
import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.MAtmosLogger;
import eu.ha3.matmos.engine.SugarList;
import eu.ha3.matmos.engine.Switchable;
import java.util.ArrayList;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class Condition
extends Switchable {
    private String sheet = "";
    private int key = 0;
    private String dynamicKey = "";
    private int conditionType = 0;
    private int constant = 0;
    private String list = "";
    private boolean isTrueEvaluated;

    public Condition(Knowledge knowledgeIn) {
        super(knowledgeIn);
    }

    public void setSheet(String sheetIn) {
        this.sheet = sheetIn;
        this.flagNeedsTesting();
    }

    public void setKey(int keyIn) {
        this.key = keyIn;
        this.flagNeedsTesting();
    }

    public void setDynamic(String dynamicKeyIn) {
        this.key = -1;
        this.dynamicKey = dynamicKeyIn;
        this.sheet = "";
        this.flagNeedsTesting();
    }

    public void setSymbol(String symbol) {
        this.conditionType = -1;
        if (symbol.equals("!=")) {
            this.conditionType = 0;
        } else if (symbol.equals("==")) {
            this.conditionType = 1;
        } else if (symbol.equals(">")) {
            this.conditionType = 2;
        } else if (symbol.equals(">=")) {
            this.conditionType = 3;
        } else if (symbol.equals("<")) {
            this.conditionType = 4;
        } else if (symbol.equals("<=")) {
            this.conditionType = 5;
        } else if (symbol.equals("in")) {
            this.conditionType = 6;
        } else if (symbol.equals("!in")) {
            this.conditionType = 7;
        }
        this.flagNeedsTesting();
    }

    public void setConstant(int constantIn) {
        this.constant = constantIn;
        this.flagNeedsTesting();
    }

    public void setList(String listIn) {
        this.list = listIn;
        this.flagNeedsTesting();
    }

    public boolean isDynamic() {
        return this.key == -1;
    }

    public String getSheet() {
        return this.sheet;
    }

    public int getKey() {
        return this.key;
    }

    public String getDynamic() {
        return this.dynamicKey;
    }

    public String getList() {
        return this.list;
    }

    public int getConditionType() {
        return this.conditionType;
    }

    public int getConstant() {
        return this.constant;
    }

    @Override
    protected boolean testIfValid() {
        if (this.conditionType == -1) {
            return false;
        }
        boolean valid = false;
        if (!this.isDynamic()) {
            if (this.knowledge.data.sheets.containsKey(this.sheet) && this.key >= 0 && this.key < ((ArrayList)this.knowledge.data.sheets.get(this.sheet)).size()) {
                valid = true;
            }
        } else if (this.knowledge.dynamics.containsKey(this.dynamicKey)) {
            valid = true;
        }
        if (valid && (this.conditionType == 6 || this.conditionType == 7)) {
            valid = this.knowledge.lists.containsKey(this.list);
        }
        return valid;
    }

    public boolean evaluate() {
        if (!this.isValid()) {
            return false;
        }
        boolean pre = this.isTrueEvaluated;
        this.isTrueEvaluated = this.testIfTrue();
        if (pre != this.isTrueEvaluated) {
            MAtmosLogger.LOGGER.finer("C:" + this.nickname + (this.isTrueEvaluated ? " now On." : " now Off."));
        }
        return this.isTrueEvaluated;
    }

    @Override
    public boolean isActive() {
        return this.isTrue();
    }

    public boolean isTrue() {
        return this.isTrueEvaluated;
    }

    public boolean testIfTrue() {
        if (!this.isValid()) {
            return false;
        }
        int gotValue = !this.isDynamic() ? (Integer)((ArrayList)this.knowledge.data.sheets.get(this.sheet)).get(this.key) : ((Dynamic)this.knowledge.dynamics.get((Object)this.dynamicKey)).value;
        if (this.conditionType == 0) {
            return gotValue != this.constant;
        }
        if (this.conditionType == 1) {
            return gotValue == this.constant;
        }
        if (this.conditionType == 2) {
            return gotValue > this.constant;
        }
        if (this.conditionType == 3) {
            return gotValue >= this.constant;
        }
        if (this.conditionType == 4) {
            return gotValue < this.constant;
        }
        if (this.conditionType == 5) {
            return gotValue <= this.constant;
        }
        if (this.conditionType == 6) {
            return ((SugarList)this.knowledge.lists.get(this.list)).contains(gotValue);
        }
        if (this.conditionType == 7) {
            return !((SugarList)this.knowledge.lists.get(this.list)).contains(gotValue);
        }
        return false;
    }

    @Override
    public String serialize(XMLEventWriter eventWriter) throws XMLStreamException {
        this.buildDescriptibleSerialized(eventWriter);
        if (!this.isDynamic()) {
            this.createNode(eventWriter, "sheet", this.sheet);
            this.createNode(eventWriter, "key", "" + this.key);
        } else {
            this.createNode(eventWriter, "key", "" + this.key);
            this.createNode(eventWriter, "dynamickey", this.dynamicKey);
        }
        if (this.conditionType == 0) {
            this.createNode(eventWriter, "symbol", "!=");
        } else if (this.conditionType == 1) {
            this.createNode(eventWriter, "symbol", "==");
        } else if (this.conditionType == 2) {
            this.createNode(eventWriter, "symbol", ">");
        } else if (this.conditionType == 3) {
            this.createNode(eventWriter, "symbol", ">=");
        } else if (this.conditionType == 4) {
            this.createNode(eventWriter, "symbol", "<");
        } else if (this.conditionType == 5) {
            this.createNode(eventWriter, "symbol", "<=");
        } else if (this.conditionType == 6) {
            this.createNode(eventWriter, "symbol", "in");
        } else if (this.conditionType == 7) {
            this.createNode(eventWriter, "symbol", "!in");
        } else {
            this.createNode(eventWriter, "symbol", "><");
        }
        this.createNode(eventWriter, "constant", "" + this.constant);
        this.createNode(eventWriter, "list", "" + this.list);
        return "";
    }

    public void replaceDynamicName(String name, String newName) {
        if (!this.isDynamic()) {
            return;
        }
        if (this.dynamicKey.equals(name)) {
            this.dynamicKey = newName;
        }
        this.flagNeedsTesting();
    }

    public void replaceListName(String name, String newName) {
        if (this.list.equals(name)) {
            this.list = newName;
        }
        this.flagNeedsTesting();
    }
}

