/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.relauncher;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class RelaunchClassLoader
extends URLClassLoader {
    private List<URL> sources;
    private ClassLoader parent;
    private List<IClassTransformer> transformers;
    private Map<String, Class> cachedClasses;
    private Set<String> invalidClasses;
    private Set<String> classLoaderExceptions = new HashSet<String>();
    private Set<String> transformerExceptions = new HashSet<String>();
    private Map<Package, Manifest> packageManifests = new HashMap<Package, Manifest>();
    private static Manifest EMPTY = new Manifest();
    private static final String[] RESERVED = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    private static final boolean DEBUG_CLASSLOADING = Boolean.parseBoolean(System.getProperty("fml.debugClassLoading", "false"));

    public RelaunchClassLoader(URL[] sources) {
        super(sources, (ClassLoader)null);
        this.sources = new ArrayList<URL>(Arrays.asList(sources));
        this.parent = this.getClass().getClassLoader();
        this.cachedClasses = new HashMap<String, Class>(1000);
        this.invalidClasses = new HashSet<String>(1000);
        this.transformers = new ArrayList<IClassTransformer>(2);
        Thread.currentThread().setContextClassLoader(this);
        this.addClassLoaderExclusion("java.");
        this.addClassLoaderExclusion("sun.");
        this.addClassLoaderExclusion("org.lwjgl.");
        this.addClassLoaderExclusion("cpw.mods.fml.relauncher.");
        this.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.addTransformerExclusion("javax.");
        this.addTransformerExclusion("org.objectweb.asm.");
        this.addTransformerExclusion("com.google.common.");
    }

    public void registerTransformer(String transformerClassName) {
        try {
            this.transformers.add((IClassTransformer)this.loadClass(transformerClassName).newInstance());
        }
        catch (Exception e2) {
            FMLRelaunchLog.log(Level.SEVERE, e2, "A critical problem occured registering the ASM transformer class %s", transformerClassName);
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.invalidClasses.contains(name)) {
            throw new ClassNotFoundException(name);
        }
        for (String st2 : this.classLoaderExceptions) {
            if (!name.startsWith(st2)) continue;
            return this.parent.loadClass(name);
        }
        if (this.cachedClasses.containsKey(name)) {
            return this.cachedClasses.get(name);
        }
        for (String st2 : this.transformerExceptions) {
            if (!name.startsWith(st2)) continue;
            try {
                Class<?> cl2 = super.findClass(name);
                this.cachedClasses.put(name, cl2);
                return cl2;
            }
            catch (ClassNotFoundException e2) {
                this.invalidClasses.add(name);
                throw e2;
            }
        }
        try {
            CodeSigner[] signers = null;
            int lastDot = name.lastIndexOf(46);
            String pkgname = lastDot == -1 ? "" : name.substring(0, lastDot);
            String fName = name.replace('.', '/').concat(".class");
            String pkgPath = pkgname.replace('.', '/');
            URLConnection urlConnection = this.findCodeSourceConnectionFor(fName);
            if (urlConnection instanceof JarURLConnection && lastDot > -1) {
                JarURLConnection jarUrlConn = (JarURLConnection)urlConnection;
                JarFile jf2 = jarUrlConn.getJarFile();
                if (jf2 != null && jf2.getManifest() != null) {
                    Manifest mf2 = jf2.getManifest();
                    JarEntry ent = jf2.getJarEntry(fName);
                    Package pkg = this.getPackage(pkgname);
                    this.getClassBytes(name);
                    signers = ent.getCodeSigners();
                    if (pkg == null) {
                        pkg = this.definePackage(pkgname, mf2, jarUrlConn.getJarFileURL());
                        this.packageManifests.put(pkg, mf2);
                    } else if (pkg.isSealed() && !pkg.isSealed(jarUrlConn.getJarFileURL())) {
                        FMLLog.severe("The jar file %s is trying to seal already secured path %s", jf2.getName(), pkgname);
                    } else if (this.isSealed(pkgname, mf2)) {
                        FMLLog.severe("The jar file %s has a security seal for path %s, but that path is defined and not secure", jf2.getName(), pkgname);
                    }
                }
            } else if (lastDot > -1) {
                Package pkg = this.getPackage(pkgname);
                if (pkg == null) {
                    pkg = this.definePackage(pkgname, null, null, null, null, null, null, null);
                    this.packageManifests.put(pkg, EMPTY);
                } else if (pkg.isSealed()) {
                    FMLLog.severe("The URL %s is defining elements for sealed path %s", urlConnection.getURL(), pkgname);
                }
            }
            byte[] basicClass = this.getClassBytes(name);
            byte[] transformedClass = this.runTransformers(name, basicClass);
            Class<?> cl3 = this.defineClass(name, transformedClass, 0, transformedClass.length, new CodeSource(urlConnection.getURL(), signers));
            this.cachedClasses.put(name, cl3);
            return cl3;
        }
        catch (Throwable e3) {
            this.invalidClasses.add(name);
            if (DEBUG_CLASSLOADING) {
                FMLLog.log(Level.FINEST, e3, "Exception encountered attempting classloading of %s", name);
            }
            throw new ClassNotFoundException(name, e3);
        }
    }

    private boolean isSealed(String path, Manifest man) {
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private URLConnection findCodeSourceConnectionFor(String name) {
        URL res = this.findResource(name);
        if (res != null) {
            try {
                return res.openConnection();
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    private byte[] runTransformers(String name, byte[] basicClass) {
        for (IClassTransformer transformer : this.transformers) {
            basicClass = transformer.transform(name, basicClass);
        }
        return basicClass;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.sources.add(url);
    }

    public List<URL> getSources() {
        return this.sources;
    }

    private byte[] readFully(InputStream stream) {
        try {
            int r2;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(stream.available());
            while ((r2 = stream.read()) != -1) {
                bos.write(r2);
            }
            return bos.toByteArray();
        }
        catch (Throwable t2) {
            FMLLog.log(Level.WARNING, t2, "Problem loading class", new Object[0]);
            return new byte[0];
        }
    }

    public List<IClassTransformer> getTransformers() {
        return Collections.unmodifiableList(this.transformers);
    }

    private void addClassLoaderExclusion(String toExclude) {
        this.classLoaderExceptions.add(toExclude);
    }

    void addTransformerExclusion(String toExclude) {
        this.transformerExceptions.add(toExclude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getClassBytes(String name) throws IOException {
        if (name.indexOf(46) == -1) {
            for (String res : RESERVED) {
                byte[] data;
                if (!name.toUpperCase(Locale.ENGLISH).startsWith(res) || (data = this.getClassBytes("_" + name)) == null) continue;
                return data;
            }
        }
        InputStream classStream = null;
        URL classResource = this.findResource(name.replace('.', '/').concat(".class"));
        if (classResource == null) {
            if (DEBUG_CLASSLOADING) {
                FMLLog.finest("Failed to find class resource %s", name.replace('.', '/').concat(".class"));
            }
            byte[] byArray = null;
            return byArray;
        }
        classStream = classResource.openStream();
        if (DEBUG_CLASSLOADING) {
            FMLLog.finest("Loading class %s from resource %s", name, classResource.toString());
        }
        byte[] byArray = this.readFully(classStream);
        return byArray;
        finally {
            if (classStream != null) {
                try {
                    classStream.close();
                }
                catch (IOException e2) {}
            }
        }
    }
}

