/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.util.property.simple.ConfigProperty;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MAtUpdateNotifier
extends Thread {
    private MAtMod mod;
    private int lastFound = 21;
    private int displayCount = 3;
    private int displayRemaining = 0;
    private boolean enabled = true;

    MAtUpdateNotifier(MAtMod mAtmosHaddon) {
        this.mod = mAtmosHaddon;
    }

    public void attempt() {
        if (!this.enabled) {
            return;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            URL url = new URL("http://q.mc.ha3.eu/query/matmos-main-version.xml");
            InputStream contents = url.openStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            Document doc = db2.parse(contents);
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp2 = xpf.newXPath();
            NodeList nl2 = doc.getElementsByTagName("release");
            int maxvn = 0;
            for (int i2 = 0; i2 < nl2.getLength(); ++i2) {
                int vn2;
                Node release = nl2.item(i2);
                String versionnumber = xp2.evaluate("./version", release);
                if (versionnumber == null || (vn2 = Integer.parseInt(versionnumber)) <= maxvn) continue;
                maxvn = vn2;
            }
            MAtMod.LOGGER.info("Update version found: " + maxvn);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                return;
            }
            if (maxvn > 21) {
                boolean needsSave = false;
                if (maxvn != this.lastFound) {
                    this.lastFound = maxvn;
                    this.displayRemaining = this.displayCount;
                    needsSave = true;
                    this.mod.getConfig().setProperty("update_found.version", this.lastFound);
                    this.mod.getConfig().setProperty("update_found.display.remaining.value", this.displayRemaining);
                }
                if (this.displayRemaining > 0) {
                    --this.displayRemaining;
                    this.mod.getConfig().setProperty("update_found.display.remaining.value", this.displayRemaining);
                    int vc2 = maxvn - 21;
                    this.mod.printChat("\u00a76", "A ", "\u00a7f", "r" + maxvn, "\u00a76", " update is available (You're ", "\u00a7f", vc2, "\u00a76", " version" + (vc2 > 1 ? "s" : "") + " late).");
                    if (this.displayRemaining > 0) {
                        this.mod.printChat("\u00a77", "This message will display ", "\u00a7f", this.displayRemaining, "\u00a77", " more time" + (this.displayRemaining > 1 ? "s" : "") + ".");
                    } else {
                        this.mod.printChat("\u00a77", "You won't be notified anymore until a newer version.");
                    }
                    needsSave = true;
                }
                if (needsSave) {
                    this.mod.saveConfig();
                }
            }
        }
        catch (XPathExpressionException e3) {
            e3.printStackTrace();
        }
        catch (MalformedURLException e4) {
            e4.printStackTrace();
        }
        catch (ParserConfigurationException e5) {
            e5.printStackTrace();
        }
        catch (IOException e6) {
            e6.printStackTrace();
        }
        catch (SAXException e7) {
            e7.printStackTrace();
        }
    }

    public void loadConfig(ConfigProperty configuration) {
        this.enabled = configuration.getBoolean("update_found.enabled");
        this.lastFound = configuration.getInteger("update_found.version");
        this.displayRemaining = configuration.getInteger("update_found.display.remaining.value");
        this.displayCount = configuration.getInteger("update_found.display.count.value");
    }
}

