/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;

public class MAtExpansionManager {
    private MAtMod mod;
    private Map expansions;
    private List soundManagers;
    private File expansionsFolder;
    private File userconfigFolder;
    private boolean canBuildKnowledge;

    public MAtExpansionManager(MAtMod mAtmosHaddon) {
        this.mod = mAtmosHaddon;
        this.expansions = new ConcurrentHashMap();
        this.soundManagers = new ArrayList();
        this.expansionsFolder = new File(Minecraft.b(), "matmos/expansions_r12/");
        this.userconfigFolder = new File(Minecraft.b(), "matmos/expansions_r12_userconfig/");
        if (!this.expansionsFolder.exists()) {
            this.expansionsFolder.mkdirs();
        }
        if (!this.userconfigFolder.exists()) {
            this.userconfigFolder.mkdirs();
        }
    }

    private void renewExpansionProngs(MAtExpansion expansion) {
        MAtSoundManagerChild soundManager = new MAtSoundManagerChild(this.mod);
        this.soundManagers.add(soundManager);
        expansion.setSoundManager(soundManager);
        expansion.setData(this.mod.getDataGatherer().getData());
    }

    public void createExpansionEntry(String userDefinedIdentifier) {
        MAtExpansion expansion = new MAtExpansion(userDefinedIdentifier);
        this.expansions.put(userDefinedIdentifier, expansion);
        this.renewExpansionProngs(expansion);
    }

    public void addExpansionFromFile(String userDefinedIdentifier, File file) {
        try {
            this.addExpansion(userDefinedIdentifier, new FileInputStream(file));
        }
        catch (FileNotFoundException e2) {
            MAtMod.LOGGER.warning("Error with FileNotFound on ExpansionLoader (on file " + file.getAbsolutePath() + ").");
        }
    }

    public void addExpansion(String userDefinedIdentifier, InputStream stream) {
        if (!this.expansions.containsKey(userDefinedIdentifier)) {
            MAtMod.LOGGER.severe("Tried to add an expansion that has no entry!");
            return;
        }
        MAtExpansion expansion = (MAtExpansion)this.expansions.get(userDefinedIdentifier);
        expansion.inputStructure(stream);
        this.tryTurnOn(expansion);
    }

    private void tryTurnOn(MAtExpansion expansion) {
        if (expansion == null) {
            return;
        }
        if (!this.canBuildKnowledge) {
            return;
        }
        this.turnOnOrOff(expansion);
    }

    public void signalReadyToTurnOn() {
        this.canBuildKnowledge = true;
        for (MAtExpansion expansion : this.expansions.values()) {
            this.tryTurnOn(expansion);
        }
    }

    private void turnOnOrOff(MAtExpansion expansion) {
        if (expansion == null) {
            return;
        }
        if (this.mod.isRunning()) {
            if (expansion.getVolume() > 0.0f) {
                expansion.turnOn();
            }
        } else {
            expansion.turnOff();
        }
    }

    public synchronized void modWasTurnedOnOrOff() {
        for (MAtExpansion expansion : this.expansions.values()) {
            this.turnOnOrOff(expansion);
        }
    }

    public Map getExpansions() {
        return this.expansions;
    }

    public void soundRoutine() {
        for (MAtExpansion expansion : this.expansions.values()) {
            expansion.soundRoutine();
        }
    }

    public void dataRoutine() {
        for (MAtExpansion expansion : this.expansions.values()) {
            expansion.dataRoutine();
        }
    }

    public synchronized void clearExpansions() {
        for (MAtExpansion expansion : this.expansions.values()) {
            expansion.clear();
        }
        this.expansions.clear();
    }

    public void loadExpansions() {
        this.clearExpansions();
        ArrayList offline = new ArrayList();
        this.gatherOffline(this.expansionsFolder, offline);
        this.createExpansionEntries(offline);
        for (File file : offline) {
            this.addExpansionFromFile(file.getName(), file);
        }
    }

    private synchronized void createExpansionEntries(List offline) {
        for (File file : offline) {
            MAtMod.LOGGER.info("ExpansionLoader found offline " + file.getName() + ".");
            this.createExpansionEntry(file.getName());
        }
    }

    private void gatherOffline(File file, List files) {
        if (!file.exists()) {
            return;
        }
        for (File individual : file.listFiles()) {
            if (individual.isDirectory() || !individual.getName().endsWith(".xml")) continue;
            files.add(individual);
        }
    }
}

