/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.easy.TimeStatistic;
import eu.ha3.matmos.engine.Data;
import eu.ha3.matmos.engine.Event;
import eu.ha3.matmos.engine.Knowledge;
import eu.ha3.matmos.engine.MAtmosException;
import eu.ha3.matmos.engine.SoundRelay;
import eu.ha3.matmos.engine.UtilityLoader;
import eu.ha3.util.property.simple.ConfigProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.minecraft.client.Minecraft;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MAtExpansion
implements MAtCustomVolume {
    private DocumentBuilder documentBuilder;
    private Document document;
    private XPath xpath;
    private Knowledge knowledge;
    private String userDefinedIdentifier;
    private String docName;
    private String docDescription;
    private boolean isReady;
    private MAtExpansionError error;
    private boolean hasStructure;
    private int dataFrequency;
    private int dataCyclic;
    private SoundRelay soundManager;
    private ConfigProperty myConfiguration;
    private String friendlyName;
    private boolean isBuilding;

    public MAtExpansion(String userDefinedIdentifier) {
        this.userDefinedIdentifier = userDefinedIdentifier;
        this.isReady = false;
        this.hasStructure = false;
        this.error = MAtExpansionError.NO_DOCUMENT;
        this.docName = userDefinedIdentifier;
        this.docDescription = "";
        this.knowledge = new Knowledge();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XPathFactory xpf = XPathFactory.newInstance();
        this.xpath = xpf.newXPath();
        this.dataFrequency = 1;
        this.dataCyclic = 0;
        this.myConfiguration = new ConfigProperty();
        this.myConfiguration.setProperty("volume", Float.valueOf(1.0f));
        this.myConfiguration.setProperty("friendlyname", "");
        this.myConfiguration.commit();
        try {
            this.myConfiguration.setSource(new File(Minecraft.b(), "matmos/expansions_r12_userconfig/" + userDefinedIdentifier + ".cfg").getCanonicalPath());
            this.myConfiguration.load();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.friendlyName = this.myConfiguration.getString("friendlyname");
        if (this.friendlyName.equals("")) {
            this.friendlyName = userDefinedIdentifier;
        }
        try {
            this.documentBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            e2.printStackTrace();
            throw new RuntimeException();
        }
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setSoundManager(SoundRelay soundManager) {
        this.knowledge.setSoundManager(soundManager);
        this.soundManager = soundManager;
        this.setVolume(this.myConfiguration.getFloat("volume"));
    }

    public void setData(Data data) {
        this.knowledge.setData(data);
    }

    public void inputStructure(InputStream stream) {
        System.out.println("inputting " + this.userDefinedIdentifier);
        this.hasStructure = false;
        try {
            this.document = this.documentBuilder.parse(stream);
            NodeList explist = this.document.getElementsByTagName("expansion");
            if (explist.getLength() == 1) {
                Node exp = explist.item(0);
                String name = this.xpath.evaluate("./name", exp);
                String desc = this.xpath.evaluate("./description", exp);
                String dataFreq = this.xpath.evaluate("./data", exp);
                if (name != null) {
                    this.docName = name;
                }
                if (desc != null) {
                    this.docDescription = desc;
                }
                if (dataFreq != null) {
                    try {
                        this.dataFrequency = Integer.parseInt(dataFreq);
                        if (this.dataFrequency < 1) {
                            this.dataFrequency = 1;
                        }
                        MAtMod.LOGGER.fine("Set " + this.userDefinedIdentifier + " frequency to " + this.dataFrequency);
                    }
                    catch (NumberFormatException e2) {
                        // empty catch block
                    }
                }
            }
            this.hasStructure = true;
        }
        catch (SAXException e3) {
            this.error = MAtExpansionError.COULD_NOT_PARSE_XML;
            e3.printStackTrace();
        }
        catch (IOException e4) {
            this.error = MAtExpansionError.COULD_NOT_PARSE_XML;
            e4.printStackTrace();
        }
        catch (XPathExpressionException e5) {
            MAtMod.LOGGER.warning("Error with XPath on expansion " + this.userDefinedIdentifier);
            e5.printStackTrace();
        }
    }

    public void buildKnowledge() {
        if (this.document == null) {
            return;
        }
        if (!this.hasStructure) {
            return;
        }
        try {
            this.knowledge.patchKnowledge();
            this.isReady = UtilityLoader.getInstance().loadKnowledge(this.knowledge, this.document, false);
        }
        catch (MAtmosException e2) {
            this.error = MAtExpansionError.COULD_NOT_MAKE_KNOWLEDGE;
            e2.printStackTrace();
        }
    }

    public void soundRoutine() {
        if (this.isReady) {
            this.knowledge.soundRoutine();
            this.soundManager.routine();
        }
    }

    public void dataRoutine() {
        if (this.isReady) {
            if (this.dataFrequency > 1) {
                if (this.dataCyclic == 0) {
                    this.knowledge.dataRoutine();
                }
                this.dataCyclic = (this.dataCyclic + 1) % this.dataFrequency;
            } else {
                this.knowledge.dataRoutine();
            }
        }
    }

    public void playSample() {
        if (!this.isRunning()) {
            return;
        }
        Event event = this.knowledge.getEvent("__SAMPLE");
        if (event != null) {
            event.playSound(1.0f, 1.0f);
        }
    }

    public MAtExpansionError getError() {
        return this.error;
    }

    public String getUserDefinedName() {
        return this.userDefinedIdentifier;
    }

    public String getName() {
        return this.docName;
    }

    public String getDescription() {
        return this.docDescription;
    }

    public boolean isRunning() {
        return this.knowledge.isTurnedOn();
    }

    public void saveConfig() {
        if (this.myConfiguration.commit()) {
            this.myConfiguration.save();
        }
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasStructure() {
        return this.hasStructure;
    }

    public void turnOn() {
        if (this.isRunning()) {
            return;
        }
        if (this.getVolume() <= 0.0f) {
            return;
        }
        if (this.isBuilding) {
            return;
        }
        if (!this.isReady && this.hasStructure) {
            this.isBuilding = true;
            TimeStatistic stat = new TimeStatistic(Locale.ENGLISH);
            this.buildKnowledge();
            MAtMod.LOGGER.info("Expansion " + this.getUserDefinedName() + " loaded (" + stat.getSecondsAsString(3) + "s).");
            this.isBuilding = false;
        }
        if (this.isReady) {
            this.knowledge.turnOn();
        }
    }

    public void turnOff() {
        if (!this.isReady || !this.isRunning()) {
            return;
        }
        this.knowledge.turnOff();
    }

    @Override
    public float getVolume() {
        if (this.soundManager instanceof MAtCustomVolume) {
            return ((MAtCustomVolume)((Object)this.soundManager)).getVolume();
        }
        return 1.0f;
    }

    @Override
    public void setVolume(float volume) {
        if (this.soundManager instanceof MAtCustomVolume) {
            ((MAtCustomVolume)((Object)this.soundManager)).setVolume(volume);
            this.myConfiguration.setProperty("volume", Float.valueOf(this.getVolume()));
        }
    }

    public String getDocumentStringForm() {
        if (this.document == null) {
            return null;
        }
        StringWriter output = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(this.document), new StreamResult(output));
        }
        catch (TransformerConfigurationException e2) {
            e2.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e3) {
            e3.printStackTrace();
        }
        catch (TransformerException e4) {
            e4.printStackTrace();
        }
        return output.toString();
    }

    public void clear() {
        this.turnOff();
        this.knowledge.patchKnowledge();
        this.isReady = false;
    }
}

