/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.matmos.engine.Data;
import java.util.ArrayList;
import java.util.List;

public class MAtDataGatherer {
    static final String INSTANTS = "Instants";
    static final String DELTAS = "Deltas";
    static final String LARGESCAN = "LargeScan";
    static final String SMALLSCAN = "SmallScan";
    static final String LARGESCAN_THOUSAND = "LargeScanPerMil";
    static final String SMALLSCAN_THOUSAND = "SmallScanPerMil";
    static final String SPECIAL_LARGE = "SpecialLarge";
    static final String SPECIAL_SMALL = "SpecialSmall";
    static final String CONTACTSCAN = "ContactScan";
    static final String CONFIGVARS = "ConfigVars";
    static final String POTIONPOWER = "PotionEffectsPower";
    static final String POTIONDURATION = "PotionEffectsDuration";
    static final String CURRENTITEM_E = "CurrentItemEnchantments";
    static final String ARMOR1_E = "Armor1Enchantments";
    static final String ARMOR2_E = "Armor2Enchantments";
    static final String ARMOR3_E = "Armor3Enchantments";
    static final String ARMOR4_E = "Armor4Enchantments";
    static final int COUNT_WORLD_BLOCKS = 4096;
    static final int COUNT_INSTANTS = 128;
    static final int COUNT_CONFIGVARS = 256;
    static final int COUNT_POTIONEFFECTS = 32;
    static final int COUNT_ENCHANTMENTS = 64;
    static final int MAX_LARGESCAN_PASS = 10;
    private MAtMod mod;
    private MAtScanVolumetricModel largeScanner;
    private MAtScanVolumetricModel smallScanner;
    private MAtScanCoordsPipeline largePipeline;
    private MAtScanCoordsPipeline smallPipeline;
    private MAtProcessorModel relaxedProcessor;
    private MAtProcessorModel frequentProcessor;
    private MAtProcessorModel contactProcessor;
    private MAtProcessorModel configVarsProcessor;
    private MAtProcessorEnchantments enchantmentsCurrentItem;
    private MAtProcessorEnchantments enchantmentsArmor1;
    private MAtProcessorEnchantments enchantmentsArmor2;
    private MAtProcessorEnchantments enchantmentsArmor3;
    private MAtProcessorEnchantments enchantmentsArmor4;
    private MAtProcessorPotionQuality potionPowerProcessor;
    private MAtProcessorPotionQuality potionDurationProcessor;
    private List additionalRelaxedProcessors;
    private List additionalFrequentProcessors;
    private Data data;
    private int cyclicTick;
    private long lastLargeScanX;
    private long lastLargeScanY;
    private long lastLargeScanZ;
    private int lastLargeScanPassed;

    MAtDataGatherer(MAtMod mAtmosHaddon) {
        this.mod = mAtmosHaddon;
    }

    void resetRegulators() {
        this.lastLargeScanPassed = 10;
        this.cyclicTick = 0;
    }

    void load() {
        this.resetRegulators();
        this.largeScanner = new MAtScanVolumetricModel(this.mod);
        this.smallScanner = new MAtScanVolumetricModel(this.mod);
        this.additionalRelaxedProcessors = new ArrayList();
        this.additionalFrequentProcessors = new ArrayList();
        this.data = new Data();
        this.prepareSheets();
        this.largePipeline = new MAtPipelineIDAccumulator(this.mod, this.data, LARGESCAN, LARGESCAN_THOUSAND, 1000);
        this.smallPipeline = new MAtPipelineIDAccumulator(this.mod, this.data, SMALLSCAN, SMALLSCAN_THOUSAND, 1000);
        this.largeScanner.setPipeline(this.largePipeline);
        this.smallScanner.setPipeline(this.smallPipeline);
        this.relaxedProcessor = new MAtProcessorRelaxed(this.mod, this.data, INSTANTS, DELTAS);
        this.frequentProcessor = new MAtProcessorFrequent(this.mod, this.data, INSTANTS, DELTAS);
        this.contactProcessor = new MAtProcessorContact(this.mod, this.data, CONTACTSCAN, null);
        this.configVarsProcessor = new MAtProcessorConfig(this.mod, this.data, CONFIGVARS, null);
        this.enchantmentsCurrentItem = new MAtProcessorEnchantments(this.mod, this.data, CURRENTITEM_E, null){

            @Override
            protected ur getItem(qx player) {
                return player.bJ.g();
            }
        };
        this.enchantmentsArmor1 = new MAtProcessorEnchantments(this.mod, this.data, ARMOR1_E, null){

            @Override
            protected ur getItem(qx player) {
                return player.bJ.b[0];
            }
        };
        this.enchantmentsArmor2 = new MAtProcessorEnchantments(this.mod, this.data, ARMOR2_E, null){

            @Override
            protected ur getItem(qx player) {
                return player.bJ.b[1];
            }
        };
        this.enchantmentsArmor3 = new MAtProcessorEnchantments(this.mod, this.data, ARMOR3_E, null){

            @Override
            protected ur getItem(qx player) {
                return player.bJ.b[2];
            }
        };
        this.enchantmentsArmor4 = new MAtProcessorEnchantments(this.mod, this.data, ARMOR4_E, null){

            @Override
            protected ur getItem(qx player) {
                return player.bJ.b[3];
            }
        };
        this.potionPowerProcessor = new MAtProcessorPotionQuality(this.mod, this.data, POTIONPOWER, null){

            @Override
            protected int getQuality(lm effect) {
                return effect.c() + 1;
            }
        };
        this.potionDurationProcessor = new MAtProcessorPotionQuality(this.mod, this.data, POTIONDURATION, null){

            @Override
            protected int getQuality(lm effect) {
                return effect.b();
            }
        };
    }

    public Data getData() {
        return this.data;
    }

    void tickRoutine() {
        if (this.cyclicTick % 64 == 0) {
            ays player = this.mod.manager().getMinecraft().g;
            long x2 = (long)Math.floor(player.t);
            long y2 = (long)Math.floor(player.u);
            long z2 = (long)Math.floor(player.v);
            if (this.cyclicTick % 256 == 0) {
                if (this.lastLargeScanPassed >= 10 || Math.abs(x2 - this.lastLargeScanX) > 16L || Math.abs(y2 - this.lastLargeScanY) > 8L || Math.abs(z2 - this.lastLargeScanZ) > 16L) {
                    this.lastLargeScanX = x2;
                    this.lastLargeScanY = y2;
                    this.lastLargeScanZ = z2;
                    this.lastLargeScanPassed = 0;
                    this.largeScanner.startScan(x2, y2, z2, 64L, 32L, 64L, 8192L, null);
                } else {
                    ++this.lastLargeScanPassed;
                }
            }
            this.smallScanner.startScan(x2, y2, z2, 16L, 8L, 16L, 2048L, null);
            this.relaxedProcessor.process();
            for (MAtProcessorModel processor : this.additionalRelaxedProcessors) {
                processor.process();
            }
            this.data.flagUpdate();
        }
        this.contactProcessor.process();
        this.frequentProcessor.process();
        this.enchantmentsCurrentItem.process();
        this.enchantmentsArmor1.process();
        this.enchantmentsArmor2.process();
        this.enchantmentsArmor3.process();
        this.enchantmentsArmor4.process();
        this.potionPowerProcessor.process();
        this.potionDurationProcessor.process();
        for (MAtProcessorModel processor : this.additionalFrequentProcessors) {
            processor.process();
        }
        this.data.flagUpdate();
        if (this.cyclicTick % 2048 == 0) {
            this.configVarsProcessor.process();
        }
        this.largeScanner.routine();
        this.smallScanner.routine();
        ++this.cyclicTick;
    }

    void prepareSheets() {
        this.createSheet(LARGESCAN, 4096);
        this.createSheet(LARGESCAN_THOUSAND, 4096);
        this.createSheet(SMALLSCAN, 4096);
        this.createSheet(SMALLSCAN_THOUSAND, 4096);
        this.createSheet(CONTACTSCAN, 4096);
        this.createSheet(INSTANTS, 128);
        this.createSheet(DELTAS, 128);
        this.createSheet(POTIONPOWER, 32);
        this.createSheet(POTIONDURATION, 32);
        this.createSheet(CURRENTITEM_E, 64);
        this.createSheet(ARMOR1_E, 64);
        this.createSheet(ARMOR2_E, 64);
        this.createSheet(ARMOR3_E, 64);
        this.createSheet(ARMOR4_E, 64);
        this.createSheet(SPECIAL_LARGE, 2);
        this.createSheet(SPECIAL_SMALL, 1);
        this.createSheet(CONFIGVARS, 256);
    }

    void createSheet(String name, int count) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        this.data.sheets.put(name, array);
        for (int i2 = 0; i2 < count; ++i2) {
            array.add(0);
        }
    }
}

