/*
 * Decompiled with CFR 0.152.
 */
import eu.ha3.mc.haddon.Bridge;
import eu.ha3.mc.haddon.Haddon;
import eu.ha3.mc.haddon.Manager;
import eu.ha3.mc.haddon.SupportsChatEvents;
import eu.ha3.mc.haddon.SupportsConnectEvents;
import eu.ha3.mc.haddon.SupportsEverythingReady;
import eu.ha3.mc.haddon.SupportsFrameEvents;
import eu.ha3.mc.haddon.SupportsGuiFrameEvents;
import eu.ha3.mc.haddon.SupportsGuiTickEvents;
import eu.ha3.mc.haddon.SupportsIncomingMessages;
import eu.ha3.mc.haddon.SupportsInitialization;
import eu.ha3.mc.haddon.SupportsKeyEvents;
import eu.ha3.mc.haddon.SupportsTickEvents;
import eu.ha3.mc.haddon.UnsupportedInterfaceException;
import eu.ha3.mc.haddon.Utility;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;

public class HaddonBridgeModLoader
extends BaseMod
implements Manager,
Bridge {
    private Haddon haddon;
    private Utility utility;
    private Minecraft mc;
    private boolean supportsTick;
    private boolean supportsFrame;
    private boolean supportsGuiTick;
    private boolean supportsGuiFrame;
    private boolean supportsChat;
    private boolean supportsKey;
    private boolean supportsIncomingMessages;
    private boolean supportsEverythingReady;
    private boolean supportsConnect;
    private Set enlistedIncomingMessages;
    private Set enlistedOutgoingMessages;
    private boolean tickEnabled;
    private boolean frameEnabled;
    private boolean guiTickEnabled;
    private boolean guiFrameEnabled;
    private boolean chatEnabled;
    private Map renderPairs;
    private boolean impl_continueTicking;
    private boolean impl_continueGuiTicking;
    private long nextTick;
    private long lastGuiTick;
    private long ticksRan;

    public HaddonBridgeModLoader(Haddon haddon) {
        this.haddon = haddon;
        this.utility = new HaddonUtilityModLoader(this);
        haddon.setManager(this);
        this.supportsTick = haddon instanceof SupportsTickEvents;
        this.supportsFrame = haddon instanceof SupportsFrameEvents;
        this.supportsGuiTick = haddon instanceof SupportsGuiTickEvents;
        this.supportsGuiFrame = haddon instanceof SupportsGuiFrameEvents;
        this.supportsChat = haddon instanceof SupportsChatEvents;
        this.supportsKey = haddon instanceof SupportsKeyEvents;
        this.supportsIncomingMessages = haddon instanceof SupportsIncomingMessages;
        this.supportsEverythingReady = haddon instanceof SupportsEverythingReady;
        this.supportsConnect = haddon instanceof SupportsConnectEvents;
        this.impl_continueTicking = this.supportsTick || this.supportsFrame;
        this.impl_continueGuiTicking = this.supportsGuiTick || this.supportsGuiFrame;
        this.nextTick = -1L;
        this.lastGuiTick = -1L;
        this.mc = ModLoader.getMinecraftInstance();
        this.enlistedOutgoingMessages = new HashSet();
        if (this.supportsIncomingMessages) {
            this.enlistedIncomingMessages = new HashSet();
        }
        if (haddon instanceof SupportsInitialization) {
            ((SupportsInitialization)((Object)haddon)).onInitialize();
        }
    }

    @Override
    public Haddon getHaddon() {
        return this.haddon;
    }

    @Override
    public void load() {
        this.haddon.onLoad();
        if (this.supportsTick && !this.supportsFrame) {
            ModLoader.setInGameHook(this, true, true);
        } else if (this.supportsFrame) {
            ModLoader.setInGameHook(this, true, false);
        }
        if (this.supportsGuiTick && !this.supportsGuiFrame) {
            ModLoader.setInGUIHook(this, true, true);
        } else if (this.supportsGuiFrame) {
            ModLoader.setInGUIHook(this, true, false);
        }
    }

    @Override
    public Minecraft getMinecraft() {
        return this.mc;
    }

    @Override
    public boolean onTickInGame(float semi, Minecraft minecraft) {
        long tick;
        if (this.supportsTick && this.tickEnabled && (tick = System.currentTimeMillis()) > this.nextTick) {
            ((SupportsTickEvents)((Object)this.haddon)).onTick();
            this.nextTick = tick + 50L;
            ++this.ticksRan;
        }
        if (this.supportsFrame && this.frameEnabled) {
            ((SupportsFrameEvents)((Object)this.haddon)).onFrame(semi);
        }
        return this.impl_continueTicking;
    }

    @Override
    public boolean onTickInGUI(float semi, Minecraft minecraft, aul gui) {
        long tick;
        if (this.supportsGuiTick && this.guiTickEnabled && (tick = this.utility.getClientTick()) != this.lastGuiTick) {
            ((SupportsGuiTickEvents)((Object)this.haddon)).onGuiTick(gui);
            this.lastGuiTick = tick;
        }
        if (this.supportsGuiFrame && this.guiFrameEnabled) {
            ((SupportsGuiFrameEvents)((Object)this.haddon)).onGuiFrame(gui, semi);
        }
        return this.impl_continueGuiTicking;
    }

    @Override
    public void clientChat(String contents) {
        if (this.supportsChat && this.chatEnabled) {
            ((SupportsChatEvents)((Object)this.haddon)).onChat(contents);
        }
    }

    @Override
    public void hookTickEvents(boolean enable) {
        if (!this.supportsTick) {
            throw new UnsupportedInterfaceException();
        }
        this.tickEnabled = enable;
    }

    @Override
    public void hookGuiTickEvents(boolean enable) {
        if (!this.supportsGuiTick) {
            throw new UnsupportedInterfaceException();
        }
        this.guiTickEnabled = enable;
    }

    @Override
    public void hookGuiFrameEvents(boolean enable) {
        if (!this.supportsGuiFrame) {
            throw new UnsupportedInterfaceException();
        }
        this.guiFrameEnabled = enable;
    }

    @Override
    public void hookFrameEvents(boolean enable) {
        if (!this.supportsFrame) {
            throw new UnsupportedInterfaceException();
        }
        this.frameEnabled = enable;
    }

    @Override
    public void hookChatEvents(boolean enable) {
        if (!this.supportsChat) {
            throw new UnsupportedInterfaceException();
        }
        this.chatEnabled = enable;
    }

    @Override
    public String getVersion() {
        return "REMOVE ME FROM IMPL";
    }

    @Override
    public Utility getUtility() {
        return this.utility;
    }

    @Override
    public void addRenderable(Class renderable, Object renderer) {
        if (this.renderPairs == null) {
            this.renderPairs = new HashMap();
        }
        this.renderPairs.put(renderable, renderer);
    }

    public void addRenderer(Map map) {
        if (this.renderPairs != null) {
            map.putAll(this.renderPairs);
        }
    }

    @Override
    public void addKeyBinding(arv keyBindingIn, String localization) {
        ModLoader.addLocalization(keyBindingIn.c, localization);
        ModLoader.registerKey(this, keyBindingIn, true);
    }

    @Override
    public void keyboardEvent(arv event) {
        if (!this.supportsKey) {
            return;
        }
        ((SupportsKeyEvents)((Object)this.haddon)).onKey(event);
    }

    @Override
    public void enlistIncomingMessages(String channel) {
        if (!this.supportsIncomingMessages) {
            throw new UnsupportedInterfaceException();
        }
        this.enlistedIncomingMessages.add(channel);
        ModLoader.registerPacketChannel(this, channel);
    }

    @Override
    public void enlistOutgoingMessages(String channel) {
        if (channel == null) {
            throw new IllegalArgumentException();
        }
        this.enlistedOutgoingMessages.add(channel);
    }

    @Override
    public void delistIncomingMessages(String channel) {
        if (!this.supportsIncomingMessages) {
            throw new UnsupportedInterfaceException();
        }
        this.enlistedIncomingMessages.remove(channel);
    }

    @Override
    public void delistOutgoingMessages(String channel) {
        this.enlistedOutgoingMessages.remove(channel);
    }

    @Override
    public void sendOutgoingMessage(di message) {
        ModLoader.clientSendPacket(message);
    }

    @Override
    public void clientCustomPayload(ayh var1, di message) {
        if (!this.supportsIncomingMessages) {
            return;
        }
        if (this.enlistedIncomingMessages.contains(message.a) || this.enlistedIncomingMessages.contains(null)) {
            ((SupportsIncomingMessages)((Object)this.haddon)).onIncomingMessage(message);
        }
    }

    public long bridgeTicksRan() {
        return this.ticksRan;
    }

    @Override
    public void modsLoaded() {
        if (this.supportsEverythingReady) {
            ((SupportsEverythingReady)((Object)this.haddon)).onEverythingReady();
        }
    }

    @Override
    public void clientConnect(ayh handler) {
        if (this.supportsConnect) {
            ((SupportsConnectEvents)((Object)this.haddon)).onConnectEvent(handler);
        }
    }
}

