/*
 * Copyright 2010 Mark Slater
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */

package argo.saj;

/**
 * A JsonListener is notified of events generated by a <code>SajParser</code> from a stream of JSON characters.
 * <p/>
 * The first call generated by a JSON stream will always be to <code>startDocument()</code> and the last will be
 * to <code>endDocument()</code>.
 *
 * @see SajParser
 */
public interface JsonListener {

    void startDocument();

    void endDocument();

    void startArray();

    void endArray();

    void startObject();

    void endObject();

    void startField(String name);

    void endField();

    void stringValue(String value);

    void numberValue(String value);

    void trueValue();

    void falseValue();

    void nullValue();
}
