/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import codechicken.nei.ServerPacketHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class NEIServerUtils {
    public static boolean isRaining(yc world) {
        return world.K().p();
    }

    public static void toggleRaining(yc world, boolean notify) {
        boolean raining;
        ahx worldInfo = world.K();
        boolean bl = raining = !worldInfo.p();
        if (!raining) {
            worldInfo.g(0);
            worldInfo.b(false);
            worldInfo.f(0);
            worldInfo.a(false);
        } else {
            worldInfo.g(1);
        }
        if (notify) {
            ServerUtils.sendChatToAll((String)("Rain turned " + (raining ? "on" : "off")));
        }
    }

    public static void healPlayer(qx player) {
        player.i(20);
        player.cc().a(20, 1.0f);
        player.B();
    }

    public static long getTime(yc world) {
        return world.K().g();
    }

    public static void setTime(long l, yc world) {
        world.K().c(l);
    }

    public static void setSlotContents(qx player, int slot, ur item, boolean containerInv) {
        if (slot == -999) {
            player.bJ.b(item);
        } else if (containerInv) {
            player.bL.a(slot, item);
        } else {
            player.bJ.a(slot, item);
        }
    }

    public static void deleteAllItems(iq player) {
        int i = 0;
        while (i < player.bL.c.size()) {
            ((sr)player.bL.c.get(i)).c(null);
            ++i;
        }
        player.a(player.bL, player.bL.a());
    }

    public static void setHourForward(yc world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((String)("Day " + NEIServerUtils.getTime(world) / 24000L + ". " + hour + ":00"));
        }
    }

    public static void advanceDisabledTimes(yc world) {
        int hour;
        int dim = CommonUtils.getDimension((yc)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (true) {
            int zone = newhour / 6;
            try {
                if (!NEIServerConfig.isPropertyDisabled(dim, (String)AllowedPropertyMap.idToNameMap.get(zone))) break;
                newhour = (zone + 1) % 4 * 6;
            }
            catch (NumberFormatException nfe) {
                String s = "Time: " + NEIServerUtils.getTime(world) + ", Hour: " + hour + ", NewHour: " + newhour + ", Zone: " + zone + ", Map: " + AllowedPropertyMap.idToNameMap.toString();
                ServerUtils.mc().i(s);
                throw nfe;
            }
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(qx player, ur itemstack) {
        int i = 0;
        while (i < player.bJ.k_() - 4) {
            if (player.bJ.a(i) == null) {
                return true;
            }
            ++i;
        }
        if (!itemstack.h()) {
            if (itemstack.d() == 1) {
                return false;
            }
            i = 0;
            while (i < player.bJ.k_()) {
                ur invstack = player.bJ.a(i);
                if (invstack != null && invstack.c == itemstack.c && invstack.e() && invstack.a < invstack.d() && invstack.a < player.bJ.c() && (!invstack.g() || invstack.j() == itemstack.j())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static int getSlotForStack(rq c, int firstSlot, int lastSlot, ur item) {
        sr slot;
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            slot = c.a(slotIndex);
            if (slot.d() && item.e() && (filled = slot.c().a) < slot.a() && filled < item.d() && NEIClientUtils.areStacksSameType(slot.c(), item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            slot = c.a(slotIndex);
            if (!slot.d()) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static int getSlotForStack(la inv, int firstSlot, int lastSlot, ur item) {
        int slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            int filled;
            ur slotStack = inv.a(slotIndex);
            if (slotStack != null && item.e() && (filled = slotStack.a) < inv.c() && filled < item.d() && NEIServerUtils.areStacksSameType(slotStack, item)) {
                return slotIndex;
            }
            ++slotIndex;
        }
        slotIndex = firstSlot;
        while (slotIndex < lastSlot) {
            if (inv.a(slotIndex) == null) {
                return slotIndex;
            }
            ++slotIndex;
        }
        return -1;
    }

    public static void sendNotice(String s, String permission) {
        NEIServerUtils.sendNotice(s, permission, -1);
    }

    public static void sendNotice(String s, String permission, int colour) {
        if (NEIServerConfig.canPlayerUseFeature("CONSOLE", permission)) {
            Logger.getLogger("Minecraft").info(s.replaceAll("\u00a7.", ""));
        }
        for (iq player : ServerUtils.mc().ad().b) {
            if (!NEIServerConfig.canPlayerUseFeature(player.bR, permission)) continue;
            ServerUtils.sendChatTo((iq)player, (String)s);
        }
    }

    public static boolean areStacksSameType(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return stack1.c == stack2.c && stack1.j() == stack2.j();
    }

    public static boolean areStacksSameTypeCrafting(ur stack1, ur stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.c == stack2.c && (stack1.j() == stack2.j() || stack1.j() == -1 || stack2.j() == -1 || stack1.b().n());
    }

    public static int compareStacks(ur stack1, ur stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.c != stack2.c) {
            return stack1.c - stack2.c;
        }
        if (stack1.a != stack2.a) {
            return stack1.a - stack2.a;
        }
        return stack1.j() - stack2.j();
    }

    public static boolean areStacksIdentical(ur stack1, ur stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static void givePlayerItem(iq player, ur stack, boolean infinite, LinkedList name, boolean doGive) {
        if (stack.b() == null) {
            player.a.b((ef)new cu("\u00a7fNo such item."));
            return;
        }
        StringBuilder namebuilder = new StringBuilder();
        boolean first = true;
        for (String string : name) {
            if (!first) {
                namebuilder.append(" ");
            }
            namebuilder.append(string.trim());
            first = false;
        }
        String itemname = namebuilder.toString();
        int given = 0;
        if (!doGive) {
            given = stack.a;
        } else if (infinite) {
            player.bJ.a(stack);
        } else {
            int increment = stack.d();
            given = 0;
            while (given < stack.a) {
                int qty = Math.min(stack.a - given, increment);
                int slotNo = NEIServerUtils.getSlotForStack((la)player.bJ, 0, 36, stack);
                if (slotNo == -1) break;
                ur slotStack = player.bJ.a(slotNo);
                int current = slotStack != null ? slotStack.a : 0;
                qty = Math.min(qty, player.bJ.c() - current);
                player.bJ.a(slotNo, NEIServerUtils.copyStack(stack, qty + current));
                given += qty;
            }
        }
        if (infinite) {
            NEIServerUtils.sendNotice("Giving " + player.bR + " infinite " + "\u00a7f" + itemname, "notify-item");
        } else {
            NEIServerUtils.sendNotice("Giving " + player.bR + " " + given + " of " + "\u00a7f" + itemname, "notify-item");
        }
        player.bL.b();
    }

    public static ur copyStack(ur itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.a += i;
        return itemstack.a(i);
    }

    public static ur copyStack(ur itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.a);
    }

    public static boolean isMagnetMode(iq player) {
        return NEIServerConfig.forPlayer(player.bR).getMagnetMode();
    }

    public static void toggleMagnetMode(iq player) {
        PlayerSave playerSave;
        playerSave.setMagnetMode(!(playerSave = NEIServerConfig.forPlayer(player.bR)).getMagnetMode());
        ServerPacketHandler.sendMagnetModeTo(player, playerSave.getMagnetMode());
    }

    public static int getCreativeMode(iq player) {
        if (NEIServerConfig.forPlayer(player.bR).getCreativeInv()) {
            return 2;
        }
        if (player.c.d()) {
            return 1;
        }
        return 0;
    }

    public static void toggleCreativeMode(iq player) {
        int mode = (NEIServerUtils.getCreativeMode(player) + 1) % 3;
        player.c.a(mode == 0 ? yl.b : yl.c);
        NEIServerConfig.forPlayer(player.bR).setCreativeInv(mode == 2);
        ServerPacketHandler.sendCreativeModeTo(player, mode);
    }

    public static void cycleCreativeInv(iq player, int steps) {
        int col;
        int col2;
        qw inventory = player.bJ;
        ur[][] slots = new ur[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.bR);
        int hotbar = 0;
        while (hotbar < 9) {
            slots[9][hotbar] = inventory.a[hotbar];
            ++hotbar;
        }
        int row = 0;
        while (row < 3) {
            col2 = 0;
            while (col2 < 9) {
                slots[row + 6][col2] = inventory.a[(row + 1) * 9 + col2];
                ++col2;
            }
            ++row;
        }
        row = 0;
        while (row < 6) {
            col2 = 0;
            while (col2 < 9) {
                slots[row][col2] = playerSave.creativeInv[row * 9 + col2];
                ++col2;
            }
            ++row;
        }
        ur[][] newslots = new ur[10][];
        int row2 = 0;
        while (row2 < 10) {
            newslots[(row2 + steps + 10) % 10] = slots[row2];
            ++row2;
        }
        int hotbar2 = 0;
        while (hotbar2 < 9) {
            inventory.a[hotbar2] = newslots[9][hotbar2];
            ++hotbar2;
        }
        row2 = 0;
        while (row2 < 3) {
            col = 0;
            while (col < 9) {
                inventory.a[(row2 + 1) * 9 + col] = newslots[row2 + 6][col];
                ++col;
            }
            ++row2;
        }
        row2 = 0;
        while (row2 < 6) {
            col = 0;
            while (col < 9) {
                playerSave.creativeInv[row2 * 9 + col] = newslots[row2][col];
                ++col;
            }
            ++row2;
        }
        playerSave.setDirty();
    }

    public static List getEnchantments(ur itemstack) {
        by nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.q()) != null) {
            int i = 0;
            while (i < nbttaglist.c()) {
                short word0 = ((bq)nbttaglist.b(i)).d("id");
                short word1 = ((bq)nbttaglist.b(i)).d("lvl");
                int[] ai = new int[]{word0, word1};
                arraylist.add(ai);
                ++i;
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(ur itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ur itemstack, int e) {
        List allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List enchantments, xc e) {
        for (int[] ai : enchantments) {
            if (e.a(xc.b[ai[0]])) continue;
            return true;
        }
        return false;
    }
}

