/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClientUtils;
import codechicken.core.NetworkClosedException;
import codechicken.core.packet.PacketCustom;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.ClientHandler;
import codechicken.nei.ContainerCreativeInv;
import codechicken.nei.ExtendedCreativeInv;
import codechicken.nei.GuiEnchantmentModifier;
import codechicken.nei.GuiExtendedCreativeInv;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.forge.GuiContainerManager;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ClientPacketHandler
implements PacketCustom.ICustomPacketHandler.IClientPacketHandler {
    public static final String channel = "NEI";

    public void handlePacket(PacketCustom packet, ayh nethandler, Minecraft mc) {
        switch (packet.getType()) {
            case 1: {
                this.handleSMPCheck(packet.readUnsignedByte(), packet.readString(), (yc)mc.e);
                break;
            }
            case 6: {
                NEIClientConfig.setMagnetMode(packet.readBoolean());
                break;
            }
            case 7: {
                NEIClientConfig.setCreativeMode(packet.readUnsignedByte());
                break;
            }
            case 10: {
                this.handlePermissableActions(packet);
                break;
            }
            case 11: {
                this.handleBannedBlocks(packet);
                break;
            }
            case 12: {
                this.handleDisabledProperties(packet);
                break;
            }
            case 13: {
                ClientHandler.instance().addSMPMagneticItem(packet.readInt(), (yc)mc.e);
                break;
            }
            case 21: {
                ClientUtils.openSMPGui((int)packet.readUnsignedByte(), (aul)new GuiEnchantmentModifier(mc.g.bJ, (yc)mc.e, 0, 0, 0));
                break;
            }
            case 23: {
                if (packet.readBoolean()) {
                    ClientUtils.openSMPGui((int)packet.readUnsignedByte(), (aul)new GuiExtendedCreativeInv(new ContainerCreativeInv((qx)mc.g, new ExtendedCreativeInv(null, Side.CLIENT))));
                    break;
                }
                mc.a((aul)new avz((qx)mc.g));
            }
        }
    }

    private void handleDisabledProperties(PacketCustom packet) {
        NEIClientConfig.resetDisabledProperties();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIClientConfig.setPropertyDisabled(packet.readUnsignedByte());
            ++i;
        }
    }

    private void handleBannedBlocks(PacketCustom packet) {
        int num = packet.readInt();
        ArrayList<ItemHash> items = new ArrayList<ItemHash>(num);
        int i = 0;
        while (i < num) {
            items.add(new ItemHash(packet.readUnsignedShort(), packet.readUnsignedShort()));
            ++i;
        }
        NEIClientConfig.setBannedBlocks(items);
        if (NEIClientUtils.getGuiContainer() != null) {
            LayoutManager.instance().refresh(NEIClientUtils.getGuiContainer());
        }
    }

    private void handlePermissableActions(PacketCustom packet) {
        NEIClientConfig.resetPermissableActions();
        int num = packet.readUnsignedByte();
        int i = 0;
        while (i < num) {
            NEIClientConfig.addPermissableAction(InterActionMap.values()[packet.readUnsignedByte()]);
            ++i;
        }
    }

    private void handleSMPCheck(int serverprotocol, String worldName, yc world) {
        if (serverprotocol > 4) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Client");
        } else if (serverprotocol < 4) {
            NEIClientUtils.addChatMessage("NEI version mismatch: Outdated Server");
        } else {
            try {
                String prefx;
                if (ClientUtils.isLocal()) {
                    prefx = "local";
                    worldName = ClientUtils.getWorldSaveName((String)worldName);
                } else {
                    try {
                        prefx = "remote/" + ClientUtils.getServerIP().replace(':', '~');
                    }
                    catch (NetworkClosedException e) {
                        return;
                    }
                }
                NEIClientConfig.loadWorld(String.valueOf(prefx) + '/' + worldName);
                NEIClientConfig.setHasSMPCounterPart(true);
                ClientPacketHandler.sendRequestLoginInfo();
            }
            catch (Exception nce) {
                nce.printStackTrace();
            }
        }
    }

    public static void sendSpawnItem(ur spawnstack, boolean infinite, boolean doSpawn) {
        PacketCustom packet = new PacketCustom((Object)channel, 1);
        packet.writeBoolean(infinite);
        packet.writeBoolean(doSpawn);
        List name = GuiContainerManager.itemDisplayNameMultiline(spawnstack, null, false);
        packet.writeByte(name.size());
        for (String s : name) {
            packet.writeString(s);
        }
        packet.writeItemStack(spawnstack);
        packet.writeInt(spawnstack.a);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendDeleteAllItems() {
        PacketCustom packet = new PacketCustom((Object)channel, 4);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendStateLoad(ur[] state) {
        ClientPacketHandler.sendDeleteAllItems();
        int slot = 0;
        while (slot < state.length) {
            ur item = state[slot];
            if (item != null) {
                ClientPacketHandler.sendSetSlot(slot, item, false);
            }
            ++slot;
        }
        PacketCustom packet = new PacketCustom((Object)channel, 11);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendSetSlot(int slot, ur stack, boolean container) {
        PacketCustom packet = new PacketCustom((Object)channel, 5);
        packet.writeBoolean(container);
        packet.writeShort(slot);
        packet.writeItemStack(stack);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    private static void sendRequestLoginInfo() {
        PacketCustom packet = new PacketCustom((Object)channel, 10);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendToggleMagnetMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 6);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendSetTime(int hour) {
        PacketCustom packet = new PacketCustom((Object)channel, 7);
        packet.writeByte(hour);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendHeal() {
        PacketCustom packet = new PacketCustom((Object)channel, 8);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendToggleRain() {
        PacketCustom packet = new PacketCustom((Object)channel, 9);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendOpenEnchantmentWindow() {
        PacketCustom packet = new PacketCustom((Object)channel, 21);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendModifyEnchantment(int enchID, int level, boolean add) {
        PacketCustom packet = new PacketCustom((Object)channel, 22);
        packet.writeByte(enchID);
        packet.writeByte(level);
        packet.writeBoolean(add);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendSetPropertyDisabled(String name, boolean enable) {
        PacketCustom packet = new PacketCustom((Object)channel, 12);
        packet.writeByte(((Integer)AllowedPropertyMap.nameToIDMap.get(name)).intValue());
        packet.writeBoolean(enable);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendCycleCreativeMode() {
        PacketCustom packet = new PacketCustom((Object)channel, 13);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendCreativeInv(boolean open) {
        PacketCustom packet = new PacketCustom((Object)channel, 23);
        packet.writeBoolean(open);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendCreativeScroll(int steps) {
        PacketCustom packet = new PacketCustom((Object)channel, 14);
        packet.writeInt(steps);
        ClientUtils.sendPacket((ef)packet.toPacket());
    }

    public static void sendMobSpawnerID(int x, int y, int z, String mobtype) {
        PacketCustom packet = new PacketCustom((Object)channel, 15);
        packet.writeCoord(x, y, z);
        packet.writeString(mobtype);
        packet.sendToServer();
    }
}

