/*
 * Decompiled with CFR 0.152.
 */
package sharose.mods.guiapi;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import sharose.mods.guiapi.GuiWidgetScreen;
import sharose.mods.guiapi.ModSettings;

public class WidgetItem2DRender
extends Widget {
    private static Field isDrawingField;
    private static bce itemRenderer;
    private ur renderStack;
    private int scaleType = 0;

    public WidgetItem2DRender() {
        this(0);
    }

    public WidgetItem2DRender(int renderID) {
        this(new ur(renderID, 0, 0));
    }

    public WidgetItem2DRender(ur renderStack) {
        this.setMinSize(16, 16);
        this.setTheme("/progressbar");
        this.setRenderStack(renderStack);
    }

    public int getRenderID() {
        return this.renderStack == null ? 0 : this.renderStack.c;
    }

    public ur getRenderStack() {
        return this.renderStack;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    private boolean isDrawing(baz tesselator) {
        if (isDrawingField == null) {
            return false;
        }
        try {
            isDrawingField.getBoolean(tesselator);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void paintWidget(GUI gui) {
        int stackBeforeDraw;
        GuiWidgetScreen screen;
        block14: {
            Minecraft minecraft = ModSettings.getMcinst();
            int x = this.getX();
            int y = this.getY();
            float scalex = 1.0f;
            float scaley = 1.0f;
            int maxWidth = this.getInnerWidth() - 4;
            int maxHeight = this.getInnerHeight() - 4;
            int scale = this.getScaleType();
            if (scale == -1 && (maxWidth < 16 || maxHeight < 16)) {
                scale = 0;
            }
            switch (scale) {
                case 0: {
                    int size = 0;
                    size = maxWidth > maxHeight ? maxHeight : maxWidth;
                    x += (maxWidth - size) / 2;
                    y += (maxHeight - size) / 2;
                    scaley = scalex = (float)size / 16.0f;
                    x = (int)((float)x / scalex);
                    y = (int)((float)y / scaley);
                    break;
                }
                case -1: {
                    int size = maxWidth - 16;
                    x += size / 2;
                    size = maxHeight - 16;
                    y += size / 2;
                    break;
                }
                case 1: {
                    scalex = (float)maxWidth / 16.0f;
                    scaley = (float)maxHeight / 16.0f;
                    x = (int)((float)x / scalex);
                    y = (int)((float)y / scaley);
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException("Scale Type is out of bounds! This should never happen!");
                }
            }
            x += 2;
            ++y;
            if (minecraft == null || this.getRenderStack() == null || this.getRenderStack().b() == null) {
                return;
            }
            screen = GuiWidgetScreen.getInstance();
            screen.renderer.pauseRendering();
            screen.renderer.setClipRect();
            GL11.glEnable((int)3089);
            GL11.glPushMatrix();
            GL11.glDisable((int)3042);
            GL11.glEnable((int)32826);
            arw.b();
            arw.c();
            GL11.glScalef((float)scalex, (float)scaley, (float)1.0f);
            ur stack = this.getRenderStack();
            if (this.isDrawing(baz.a)) {
                this.setDrawing(baz.a, false);
            }
            stackBeforeDraw = GL11.glGetInteger((int)2979);
            try {
                itemRenderer.a(minecraft.p, minecraft.o, stack, x, y);
                if (this.isDrawing(baz.a)) {
                    this.setDrawing(baz.a, false);
                }
                itemRenderer.c(minecraft.p, minecraft.o, stack, x, y);
                if (this.isDrawing(baz.a)) {
                    this.setDrawing(baz.a, false);
                }
            }
            catch (Throwable e) {
                if (!this.isDrawing(baz.a)) break block14;
                this.setDrawing(baz.a, false);
            }
        }
        int stackAfterDraw = GL11.glGetInteger((int)2979);
        if (stackBeforeDraw != stackAfterDraw) {
            for (int i = 0; i < stackAfterDraw - stackBeforeDraw; ++i) {
                GL11.glPopMatrix();
            }
        }
        arw.a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glDisable((int)3089);
        screen.renderer.resumeRendering();
    }

    private void setDrawing(baz tesselator, boolean state) {
        if (isDrawingField == null) {
            return;
        }
        try {
            isDrawingField.setBoolean(tesselator, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setRenderID(int renderID) {
        if (renderID >= up.e.length || renderID < 0) {
            throw new IndexOutOfBoundsException(String.format("Render ID must be within the possible bounds of an Item ID! (%s - %s)", 0, up.e.length - 1));
        }
        if (this.renderStack == null) {
            this.renderStack = new ur(renderID, 0, 0);
        }
        this.renderStack.c = renderID;
    }

    public void setRenderStack(ur stack) {
        if (stack == null) {
            throw new IllegalArgumentException("stack cannot be null.");
        }
        if (stack.c >= up.e.length || stack.c < 0) {
            throw new IndexOutOfBoundsException(String.format("Render ID must be within the possible bounds of an Item ID! (%s - %s)", 0, up.e.length - 1));
        }
        this.renderStack = stack;
    }

    public void setScaleType(int scaleType) {
        if (scaleType > 1) {
            scaleType = 1;
        }
        if (scaleType < -1) {
            scaleType = -1;
        }
        this.scaleType = scaleType;
    }

    static {
        itemRenderer = new bce();
        try {
            isDrawingField = baz.class.getDeclaredField("z");
            isDrawingField.setAccessible(true);
        }
        catch (Throwable e) {
            try {
                isDrawingField = baz.class.getDeclaredField("isDrawing");
                isDrawingField.setAccessible(true);
            }
            catch (Throwable e2) {
                System.out.println("GuiAPI Warning: Unable to get Tessellator.isDrawing field! There will be a chance of crashes if you attempt to render a mod item!");
            }
        }
    }
}

