/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.Event;

public class DraggableButton
extends Button {
    private int dragStartX;
    private int dragStartY;
    private boolean dragging;
    private DragListener listener;

    public DraggableButton() {
    }

    public DraggableButton(AnimationState animState) {
        super(animState);
    }

    public DraggableButton(AnimationState animState, boolean inherit) {
        super(animState, inherit);
    }

    public boolean isDragActive() {
        return this.dragging;
    }

    public DragListener getListener() {
        return this.listener;
    }

    public void setListener(DragListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean handleEvent(Event evt) {
        if (evt.isMouseEvent() && this.dragging) {
            if (evt.getType() == Event.Type.MOUSE_DRAGGED && this.listener != null) {
                this.listener.dragged(evt.getMouseX() - this.dragStartX, evt.getMouseY() - this.dragStartY);
            }
            if (evt.isMouseDragEnd()) {
                this.stopDragging(evt);
            }
            return true;
        }
        switch (evt.getType()) {
            case MOUSE_BTNDOWN: {
                this.dragStartX = evt.getMouseX();
                this.dragStartY = evt.getMouseY();
                break;
            }
            case MOUSE_DRAGGED: {
                assert (!this.dragging);
                this.dragging = true;
                this.getModel().setArmed(false);
                this.getModel().setPressed(true);
                if (this.listener != null) {
                    this.listener.dragStarted();
                }
                return true;
            }
        }
        return super.handleEvent(evt);
    }

    private void stopDragging(Event evt) {
        if (this.listener != null) {
            this.listener.dragStopped();
        }
        this.dragging = false;
        this.getModel().setArmed(false);
        this.getModel().setPressed(false);
        this.getModel().setHover(this.isMouseInside(evt));
    }

    public static interface DragListener {
        public void dragStarted();

        public void dragged(int var1, int var2);

        public void dragStopped();
    }
}

