/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCorePlugin;
import cpw.mods.fml.relauncher.IClassTransformer;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ClassHeirachyManager
implements IClassTransformer {
    public static HashSet knownClasses = new HashSet();
    public static HashMap superclasses = new HashMap();

    public static boolean classExtends(String clazz, String superclass, byte[] bytes) {
        if (!knownClasses.contains(clazz)) {
            new ClassHeirachyManager().transform(clazz, bytes);
        }
        return ClassHeirachyManager.classExtends(clazz, superclass);
    }

    private static boolean classExtends(String clazz, String superclass) {
        block9: {
            if (clazz.equals(superclass)) {
                return true;
            }
            if (clazz.equals("java.lang.Object")) {
                return false;
            }
            try {
                if (knownClasses.contains(clazz)) break block9;
                try {
                    byte[] bytes = CodeChickenCorePlugin.cl.getClassBytes(clazz);
                    if (bytes != null) {
                        new ClassHeirachyManager().transform(clazz, bytes);
                    }
                }
                catch (Exception bytes) {
                    // empty catch block
                }
                if (!knownClasses.contains(clazz)) {
                    Class<?> aclass = Class.forName(clazz);
                    knownClasses.add(clazz);
                    superclasses.put(clazz, aclass.getSuperclass().getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (!superclasses.containsKey(clazz)) {
            return false;
        }
        return ClassHeirachyManager.classExtends((String)superclasses.get(clazz), superclass);
    }

    public byte[] transform(String name, byte[] bytes) {
        if (!knownClasses.contains(name)) {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader(bytes);
            reader.accept((ClassVisitor)node, 0);
            knownClasses.add(name);
            superclasses.put(name, node.superName.replace('/', '.'));
        }
        return bytes;
    }
}

