/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basicType;

    public ArrayType(byte type, int dimensions) {
        this(BasicType.getType(type), dimensions);
    }

    public ArrayType(String class_name, int dimensions) {
        this(ObjectType.getInstance(class_name), dimensions);
    }

    public ArrayType(Type type, int dimensions) {
        super((byte)13, "<dummy>");
        if (dimensions < 1 || dimensions > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + dimensions);
        }
        switch (type.getType()) {
            case 13: {
                ArrayType array = (ArrayType)type;
                this.dimensions = dimensions + array.dimensions;
                this.basicType = array.basicType;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = dimensions;
                this.basicType = type;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            buf.append('[');
        }
        buf.append(this.basicType.getSignature());
        super.setSignature(buf.toString());
    }

    public Type getBasicType() {
        return this.basicType;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basicType;
        }
        return new ArrayType(this.basicType, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int hashCode() {
        return this.basicType.hashCode() ^ this.dimensions;
    }

    @Override
    public boolean equals(Object _type) {
        if (_type instanceof ArrayType) {
            ArrayType array = (ArrayType)_type;
            return array.dimensions == this.dimensions && array.basicType.equals(this.basicType);
        }
        return false;
    }
}

