/*
 * Decompiled with CFR 0.152.
 */
package apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import com.apple.laf.AquaImageFactory;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public final class JRSUIUtils {
    static boolean isLeopard = JRSUIUtils.isMacOSXLeopard();
    static boolean isSnowLeopardOrBelow = JRSUIUtils.isMacOSXSnowLeopardOrBelow();

    public static boolean isMacOSXBigSurOrAbove() {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(10, 16, true, false, true);
    }

    static boolean isMacOSXLeopard() {
        return JRSUIUtils.isCurrentMacOSXVersion(5);
    }

    static boolean isMacOSXSnowLeopardOrBelow() {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(10, 6, true, true, false);
    }

    static boolean isCurrentMacOSXVersion(int n) {
        return JRSUIUtils.isCurrentMacOSXVersion(10, n);
    }

    static boolean isCurrentMacOSXVersion(int n, int n2) {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(n, n2, true, false, false);
    }

    static boolean currentMacOSXVersionMatchesGivenVersionRange(int n, boolean bl, boolean bl2, boolean bl3) {
        return JRSUIUtils.currentMacOSXVersionMatchesGivenVersionRange(10, n, bl, bl2, bl3);
    }

    static boolean currentMacOSXVersionMatchesGivenVersionRange(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.version"));
        String[] stringArray = string.split("\\.");
        if (stringArray.length < 2) {
            return false;
        }
        try {
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            if (bl && n3 == n && n4 == n2) {
                return true;
            }
            if (bl2 && (n3 < n || n3 == n && n4 < n2)) {
                return true;
            }
            if (bl3 && (n3 > n || n3 == n && n4 > n2)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static interface NineSliceMetricsProvider {
        public AquaImageFactory.NineSliceMetrics getNineSliceMetricsForState(JRSUIState var1);
    }

    public static class HitDetection {
        public static JRSUIConstants.Hit getHitForPoint(JRSUIControl jRSUIControl, int n, int n2, int n3, int n4, int n5, int n6) {
            return jRSUIControl.getHitForPoint(n, n2, n3, n4, n5, n6);
        }
    }

    public static class Images {
        public static boolean shouldUseLegacySecurityUIPath() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class ScrollBar {
        private static native boolean shouldUseScrollToClick();

        public static boolean useScrollToClick() {
            return ScrollBar.shouldUseScrollToClick();
        }

        public static void getPartBounds(double[] dArray, JRSUIControl jRSUIControl, int n, int n2, int n3, int n4, JRSUIConstants.ScrollBarPart scrollBarPart) {
            jRSUIControl.getPartBounds(dArray, n, n2, n3, n4, scrollBarPart.ordinal);
        }

        public static double getNativeOffsetChange(JRSUIControl jRSUIControl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            return jRSUIControl.getScrollBarOffsetChange(n, n2, n3, n4, n5, n6, n7);
        }
    }

    public static class Tree {
        public static boolean useLegacyTreeKnobs() {
            return isLeopard;
        }
    }

    public static class InternalFrame {
        public static boolean shouldUseLegacyBorderMetrics() {
            return isSnowLeopardOrBelow;
        }
    }

    public static class TabbedPane {
        public static boolean useLegacyTabs() {
            return isLeopard;
        }

        public static boolean shouldUseTabbedPaneContrastUI() {
            return !isSnowLeopardOrBelow;
        }
    }
}

