/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;

final class TimelineColorFactory {
    private static final Color[] PREDEFINED_COLORS = new Color[]{new Color(241, 154, 42), new Color(32, 171, 217), new Color(144, 97, 207), new Color(158, 156, 0)};
    private static final Color[][] PREDEFINED_GRADIENTS = new Color[][]{{new Color(245, 204, 152), new Color(255, 243, 226)}, {new Color(151, 223, 246), new Color(227, 248, 255)}, {new Color(200, 163, 248), new Color(242, 232, 255)}, {new Color(212, 211, 131), new Color(244, 243, 217)}};

    TimelineColorFactory() {
    }

    private static Color getPredefinedColor(int n) {
        return PREDEFINED_COLORS[n];
    }

    static Color getColor(int n) {
        Color color;
        if (n >= PREDEFINED_COLORS.length) {
            color = TimelineColorFactory.getPredefinedColor(n % PREDEFINED_COLORS.length);
            int n2 = n / PREDEFINED_COLORS.length;
            while (n2-- > 0) {
                color = color.darker();
            }
        } else {
            color = TimelineColorFactory.getPredefinedColor(n);
        }
        return color;
    }

    private static Color[] getPredefinedGradient(int n) {
        return PREDEFINED_GRADIENTS[n];
    }

    static Color[] getGradient(int n) {
        Color[] colorArray = null;
        if (n >= PREDEFINED_GRADIENTS.length) {
            colorArray = TimelineColorFactory.getPredefinedGradient(n % PREDEFINED_GRADIENTS.length);
            int n2 = n / PREDEFINED_GRADIENTS.length;
            while (n2-- > 0) {
                colorArray[0] = colorArray[0].darker();
                colorArray[1] = colorArray[1].darker();
            }
        } else {
            colorArray = TimelineColorFactory.getPredefinedGradient(n);
        }
        return colorArray;
    }
}

