/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.util.Lookup;

class LogFormatter
extends XMLFormatter {
    private final Pattern javaHome;
    private final Pattern userHome;
    private final Pattern netbeansUserDir;
    private final Pattern netbeansHome;
    private final List<Pattern> installDirs;
    private final Pattern filePrefix = Pattern.compile("file:", 16);
    private final Pattern nbjclPrefix = Pattern.compile("nbjcl:", 16);
    private final Pattern jarPrefix = Pattern.compile("jar:", 16);
    private final Pattern hexPattern = Pattern.compile("@[0-9a-fA-F]*");

    public LogFormatter() {
        this.javaHome = this.convert(System.getProperty("java.home", ""));
        this.userHome = this.convert(System.getProperty("user.home", ""));
        this.netbeansUserDir = this.convert(System.getProperty("netbeans.user", ""));
        this.netbeansHome = this.convert(System.getProperty("netbeans.home", ""));
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            Pattern[] patternArray = new Pattern[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                patternArray[i] = this.convert(stringArray[i]);
            }
            this.installDirs = Arrays.asList(patternArray);
        } else {
            this.installDirs = Collections.emptyList();
        }
    }

    private Pattern convert(String string) {
        try {
            String string2 = new File(string).toURI().toURL().toString();
            return Pattern.compile(string2, 16);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.INFO, "unaccessible file", malformedURLException);
            return null;
        }
    }

    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c < ' ' && c != '\t' && c != '\r' && c != '\n') {
                stringBuffer.append('^').append((char)(c + 64));
                continue;
            }
            stringBuffer.append(c);
        }
    }

    private String doReplace(String string, Pattern pattern, String string2) {
        return pattern.matcher(string).replaceAll(Matcher.quoteReplacement(string2));
    }

    private void printFrame(StackTraceElement stackTraceElement, StringBuffer stringBuffer) {
        if (stackTraceElement == null) {
            return;
        }
        stringBuffer.append("    <frame>\n");
        stringBuffer.append("      <class>");
        this.escape(stringBuffer, stackTraceElement.getClassName());
        stringBuffer.append("</class>\n");
        stringBuffer.append("      <method>");
        this.escape(stringBuffer, stackTraceElement.getMethodName());
        stringBuffer.append("</method>\n");
        if (stackTraceElement.getLineNumber() >= 0) {
            stringBuffer.append("      <line>");
            stringBuffer.append(stackTraceElement.getLineNumber());
            stringBuffer.append("</line>\n");
        }
        stringBuffer.append("      <file>");
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class<?> clazz = null;
        URL uRL = null;
        String string = null;
        try {
            clazz = classLoader.loadClass(stackTraceElement.getClassName());
        }
        catch (Throwable throwable) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Class loading error", throwable);
        }
        if (clazz != null) {
            String[] stringArray = clazz.getName().split("\\.");
            if (stringArray.length > 0) {
                uRL = clazz.getResource(stringArray[stringArray.length - 1] + ".class");
            }
            if (uRL != null) {
                string = uRL.toString();
                int n = string.indexOf("!");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                string = this.doReplace(string, this.jarPrefix, "");
                if (this.javaHome != null) {
                    string = this.doReplace(string, this.javaHome, "${java.home}");
                }
                if (this.netbeansHome != null) {
                    string = this.doReplace(string, this.netbeansHome, "${netbeans.home}");
                }
                if (this.netbeansUserDir != null) {
                    string = this.doReplace(string, this.netbeansUserDir, "${user.dir}");
                }
                Iterator<Pattern> iterator = this.installDirs.iterator();
                while (iterator.hasNext()) {
                    string = this.doReplace(string, iterator.next(), "${netBeansDir}");
                }
                if (this.userHome != null) {
                    string = this.doReplace(string, this.userHome, "${user.home}");
                }
                string = this.doReplace(string, this.filePrefix, "");
                string = this.doReplace(string, this.nbjclPrefix, "");
                this.escape(stringBuffer, string);
            }
        }
        stringBuffer.append("</file>\n");
        stringBuffer.append("    </frame>\n");
    }

    private void printCause(Throwable throwable, StringBuffer stringBuffer, StackTraceElement[] stackTraceElementArray) {
        stringBuffer.append("  <exception>\n");
        stringBuffer.append("   <message>");
        this.escape(stringBuffer, throwable.toString());
        stringBuffer.append("</message>\n");
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = stackTraceElementArray2.length - 1 - n;
        for (int i = 0; i <= n; ++i) {
            this.printFrame(stackTraceElementArray2[i], stringBuffer);
        }
        stringBuffer.append("   <more>");
        stringBuffer.append(n2);
        stringBuffer.append("</more>\n");
        stringBuffer.append("  </exception>\n");
        if (throwable.getCause() != null) {
            this.printCause(throwable.getCause(), stringBuffer, stackTraceElementArray2);
        }
    }

    private void printThrown(Throwable throwable, StringBuffer stringBuffer) {
        stringBuffer.append("  <exception>\n");
        stringBuffer.append("    <message>");
        this.escape(stringBuffer, throwable.toString());
        stringBuffer.append("</message>\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            this.printFrame(stackTraceElementArray[i], stringBuffer);
        }
        stringBuffer.append("  </exception>\n");
        if (throwable.getCause() != null) {
            this.printCause(throwable.getCause(), stringBuffer, stackTraceElementArray);
        }
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append('-');
        this.a2(stringBuffer, gregorianCalendar.get(2) + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, gregorianCalendar.get(5));
        stringBuffer.append('T');
        this.a2(stringBuffer, gregorianCalendar.get(11));
        stringBuffer.append(':');
        this.a2(stringBuffer, gregorianCalendar.get(12));
        stringBuffer.append(':');
        this.a2(stringBuffer, gregorianCalendar.get(13));
    }

    @Override
    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("<record>\n");
        stringBuffer.append("  <date>");
        this.appendISO8601(stringBuffer, logRecord.getMillis());
        stringBuffer.append("</date>\n");
        stringBuffer.append("  <millis>");
        stringBuffer.append(logRecord.getMillis());
        stringBuffer.append("</millis>\n");
        stringBuffer.append("  <sequence>");
        stringBuffer.append(logRecord.getSequenceNumber());
        stringBuffer.append("</sequence>\n");
        String string = logRecord.getLoggerName();
        if (string != null) {
            stringBuffer.append("  <logger>");
            this.escape(stringBuffer, string);
            stringBuffer.append("</logger>\n");
        }
        stringBuffer.append("  <level>");
        String string2 = Integer.toString(logRecord.getLevel().intValue());
        this.escape(stringBuffer, string2);
        stringBuffer.append("</level>\n");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append("  <class>");
            this.escape(stringBuffer, logRecord.getSourceClassName());
            stringBuffer.append("</class>\n");
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append("  <method>");
            this.escape(stringBuffer, logRecord.getSourceMethodName());
            stringBuffer.append("</method>\n");
        }
        stringBuffer.append("  <thread>");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("</thread>\n");
        String string3 = logRecord.getMessage();
        if (string3 != null) {
            stringBuffer.append("  <message>");
            this.escape(stringBuffer, string3);
            stringBuffer.append("</message>\n");
        }
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        try {
            if (resourceBundle != null && resourceBundle.getString(string3) != null) {
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, string3);
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
            }
        }
        catch (Exception exception) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Catalog loading error", exception);
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null && objectArray.length != 0 && (string3 == null || string3.indexOf("{") == -1)) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("  <param>");
                try {
                    this.escape(stringBuffer, this.paramToString(objectArray[i]));
                }
                catch (Exception exception) {
                    stringBuffer.append("???");
                }
                stringBuffer.append("</param>\n");
            }
        }
        if (logRecord.getThrown() != null) {
            this.printThrown(logRecord.getThrown(), stringBuffer);
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }

    private String paramToString(Object object) {
        Object object2;
        Action action;
        if (object == null) {
            return "null";
        }
        if (object instanceof JMenuItem && (action = ((AbstractButton)(object2 = (JMenuItem)object)).getAction()) != null) {
            return object2.getClass().getName() + '[' + this.paramToString(action) + ']';
        }
        if (object instanceof AbstractButton) {
            object2 = (AbstractButton)object;
            return object2.getClass().getName() + '[' + ((AbstractButton)object2).getText() + ']';
        }
        if (object instanceof Action) {
            object2 = (Action)object;
            if (object2.getClass().getName().endsWith("$DelegateAction") && object2.getClass().getName().startsWith("org.openide")) {
                return this.hexPattern.matcher(object2.toString()).replaceAll("," + object2.getValue("Name"));
            }
            return object2.getClass().getName() + '[' + object2.getValue("Name") + ']';
        }
        if (object instanceof Component) {
            object2 = (Component)object;
            return object2.getClass().getName() + '[' + ((Component)object2).getName() + ']';
        }
        return object.toString();
    }
}

