/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyVetoException;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.Version;

public class AboutDialog
extends InternalDialog {
    private static final Color textColor = new Color(87, 88, 89);
    private static final Color bgColor = new Color(232, 237, 241);
    private static final Color borderColor = Color.black;
    private Icon mastheadIcon = new InternalDialog.MastheadIcon(this, Messages.HELP_ABOUT_DIALOG_MASTHEAD_TITLE);
    private static AboutDialog aboutDialog;
    private JLabel statusBar;
    private Action closeAction;
    private JEditorPane helpLink;
    private final String urlStr = AboutDialog.getOnlineDocUrl();

    public AboutDialog(JConsole jConsole) {
        super(jConsole, Messages.HELP_ABOUT_DIALOG_TITLE, false);
        Utilities.setAccessibleDescription(this, Messages.HELP_ABOUT_DIALOG_ACCESSIBLE_DESCRIPTION);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JComponent jComponent = (JComponent)this.getContentPane();
        this.createActions();
        JLabel jLabel = new JLabel(this.mastheadIcon);
        Utilities.setAccessibleName(jLabel, Messages.HELP_ABOUT_DIALOG_MASTHEAD_ACCESSIBLE_NAME);
        TPanel tPanel = new TPanel(0, 0);
        tPanel.add((Component)jLabel, "North");
        String string = Version.getVersion();
        String string2 = System.getProperty("java.vm.name");
        String string3 = System.getProperty("java.vm.version");
        String string4 = this.urlStr;
        if (AboutDialog.isBrowseSupported()) {
            string4 = "<a style='color:#35556b' href=\"" + string4 + "\">" + string4 + "</a>";
        }
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBackground(bgColor);
        String string5 = String.format("%06x", textColor.getRGB() & 0xFFFFFF);
        this.helpLink = new JEditorPane("text/html", "<html><font color=#" + string5 + ">" + Resources.format(Messages.HELP_ABOUT_DIALOG_JCONSOLE_VERSION, string) + "<p>" + Resources.format(Messages.HELP_ABOUT_DIALOG_JAVA_VERSION, string2 + ", " + string3) + "<p>" + string4 + "</html>");
        this.helpLink.setOpaque(false);
        this.helpLink.setEditable(false);
        this.helpLink.setForeground(textColor);
        tPanel.setBorder(BorderFactory.createLineBorder(borderColor));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.helpLink.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                    AboutDialog.this.browse(AboutDialog.this.urlStr);
                    keyEvent.consume();
                }
            }
        });
        this.helpLink.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AboutDialog.this.highlight();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AboutDialog.this.removeHighlights();
            }
        });
        this.helpLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AboutDialog.this.browse(hyperlinkEvent.getDescription());
                }
            }
        });
        jPanel.add((Component)this.helpLink, "North");
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("resources/brandlogo.png"));
        JLabel jLabel2 = new JLabel(imageIcon, 10);
        JButton jButton = new JButton(this.closeAction);
        TPanel tPanel2 = new TPanel(0, 0);
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.setOpaque(false);
        tPanel.add((Component)jPanel, "Center");
        jComponent.add((Component)tPanel2, "South");
        jPanel.add((Component)jLabel2, "South");
        jPanel2.setBorder(new EmptyBorder(2, 12, 2, 12));
        jPanel2.add(jButton);
        tPanel2.add((Component)jPanel2, "North");
        this.statusBar = new JLabel(" ");
        tPanel2.add((Component)this.statusBar, "South");
        jComponent.add((Component)tPanel, "North");
        this.pack();
        this.setLocationRelativeTo(jConsole);
        Utilities.updateTransparency(this);
    }

    public void highlight() {
        try {
            this.removeHighlights();
            Highlighter highlighter = this.helpLink.getHighlighter();
            Document document = this.helpLink.getDocument();
            String string = document.getText(0, document.getLength());
            int n = string.indexOf(this.urlStr, 0);
            highlighter.addHighlight(n, n + this.urlStr.length(), new HighlightPainter());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void removeHighlights() {
        Highlighter highlighter = this.helpLink.getHighlighter();
        highlighter.removeAllHighlights();
    }

    public void showDialog() {
        this.statusBar.setText(" ");
        this.setVisible(true);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static AboutDialog getAboutDialog(JConsole jConsole) {
        if (aboutDialog == null) {
            aboutDialog = new AboutDialog(jConsole);
        }
        return aboutDialog;
    }

    static void showAboutDialog(JConsole jConsole) {
        AboutDialog.getAboutDialog(jConsole).showDialog();
    }

    static void browseUserGuide(JConsole jConsole) {
        AboutDialog.getAboutDialog(jConsole).browse(AboutDialog.getOnlineDocUrl());
    }

    static boolean isBrowseSupported() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    void browse(String string) {
        block2: {
            try {
                Desktop.getDesktop().browse(new URI(string));
            }
            catch (Exception exception) {
                this.showDialog();
                this.statusBar.setText(exception.getLocalizedMessage());
                if (!JConsole.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void createActions() {
        this.closeAction = new AbstractAction(Messages.CLOSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.statusBar.setText("");
            }
        };
    }

    private static String getOnlineDocUrl() {
        String string = Integer.toString(sun.misc.Version.jdkMinorVersion());
        return Resources.format(Messages.HELP_ABOUT_DIALOG_USER_GUIDE_LINK_URL, string);
    }

    private static class HighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public HighlightPainter() {
            super(null);
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            graphics.setColor(jTextComponent.getSelectionColor());
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            Graphics2D graphics2D = (Graphics2D)graphics;
            float[] fArray = new float[]{2.0f, 2.0f};
            BasicStroke basicStroke = new BasicStroke(1.0f, 2, 0, 3.0f, fArray, 0.0f);
            graphics2D.fill(basicStroke.createStrokedShape(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1)));
            return rectangle;
        }
    }

    private static class TPanel
    extends JPanel {
        TPanel(int n, int n2) {
            super(new BorderLayout(n, n2));
            this.setOpaque(false);
        }
    }
}

