/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateImpl;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Ser;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.chrono.ThaiBuddhistEra;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Objects;

public final class ThaiBuddhistDate
extends ChronoLocalDateImpl<ThaiBuddhistDate>
implements ChronoLocalDate,
Serializable {
    private static final long serialVersionUID = -8722293800195731463L;
    private final transient LocalDate isoDate;

    public static ThaiBuddhistDate now() {
        return ThaiBuddhistDate.now(Clock.systemDefaultZone());
    }

    public static ThaiBuddhistDate now(ZoneId zoneId) {
        return ThaiBuddhistDate.now(Clock.system(zoneId));
    }

    public static ThaiBuddhistDate now(Clock clock) {
        return new ThaiBuddhistDate(LocalDate.now(clock));
    }

    public static ThaiBuddhistDate of(int n, int n2, int n3) {
        return new ThaiBuddhistDate(LocalDate.of(n - 543, n2, n3));
    }

    public static ThaiBuddhistDate from(TemporalAccessor temporalAccessor) {
        return ThaiBuddhistChronology.INSTANCE.date(temporalAccessor);
    }

    ThaiBuddhistDate(LocalDate localDate) {
        Objects.requireNonNull(localDate, "isoDate");
        this.isoDate = localDate;
    }

    @Override
    public ThaiBuddhistChronology getChronology() {
        return ThaiBuddhistChronology.INSTANCE;
    }

    @Override
    public ThaiBuddhistEra getEra() {
        return this.getProlepticYear() >= 1 ? ThaiBuddhistEra.BE : ThaiBuddhistEra.BEFORE_BE;
    }

    @Override
    public int lengthOfMonth() {
        return this.isoDate.lengthOfMonth();
    }

    @Override
    public ValueRange range(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (this.isSupported(temporalField)) {
                ChronoField chronoField = (ChronoField)temporalField;
                switch (chronoField) {
                    case DAY_OF_MONTH: 
                    case DAY_OF_YEAR: 
                    case ALIGNED_WEEK_OF_MONTH: {
                        return this.isoDate.range(temporalField);
                    }
                    case YEAR_OF_ERA: {
                        ValueRange valueRange = ChronoField.YEAR.range();
                        long l = this.getProlepticYear() <= 0 ? -(valueRange.getMinimum() + 543L) + 1L : valueRange.getMaximum() + 543L;
                        return ValueRange.of(1L, l);
                    }
                }
                return this.getChronology().range(chronoField);
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public long getLong(TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            switch ((ChronoField)temporalField) {
                case PROLEPTIC_MONTH: {
                    return this.getProlepticMonth();
                }
                case YEAR_OF_ERA: {
                    int n = this.getProlepticYear();
                    return n >= 1 ? n : 1 - n;
                }
                case YEAR: {
                    return this.getProlepticYear();
                }
                case ERA: {
                    return this.getProlepticYear() >= 1 ? 1 : 0;
                }
            }
            return this.isoDate.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    private long getProlepticMonth() {
        return (long)this.getProlepticYear() * 12L + (long)this.isoDate.getMonthValue() - 1L;
    }

    private int getProlepticYear() {
        return this.isoDate.getYear() + 543;
    }

    @Override
    public ThaiBuddhistDate with(TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)temporalField;
            if (this.getLong(chronoField) == l) {
                return this;
            }
            switch (chronoField) {
                case PROLEPTIC_MONTH: {
                    this.getChronology().range(chronoField).checkValidValue(l, chronoField);
                    return this.plusMonths(l - this.getProlepticMonth());
                }
                case YEAR_OF_ERA: 
                case YEAR: 
                case ERA: {
                    int n = this.getChronology().range(chronoField).checkValidIntValue(l, chronoField);
                    switch (chronoField) {
                        case YEAR_OF_ERA: {
                            return this.with(this.isoDate.withYear((this.getProlepticYear() >= 1 ? n : 1 - n) - 543));
                        }
                        case YEAR: {
                            return this.with(this.isoDate.withYear(n - 543));
                        }
                        case ERA: {
                            return this.with(this.isoDate.withYear(1 - this.getProlepticYear() - 543));
                        }
                    }
                }
            }
            return this.with(this.isoDate.with(temporalField, l));
        }
        return (ThaiBuddhistDate)super.with(temporalField, l);
    }

    @Override
    public ThaiBuddhistDate with(TemporalAdjuster temporalAdjuster) {
        return (ThaiBuddhistDate)super.with(temporalAdjuster);
    }

    @Override
    public ThaiBuddhistDate plus(TemporalAmount temporalAmount) {
        return (ThaiBuddhistDate)super.plus(temporalAmount);
    }

    @Override
    public ThaiBuddhistDate minus(TemporalAmount temporalAmount) {
        return (ThaiBuddhistDate)super.minus(temporalAmount);
    }

    @Override
    ThaiBuddhistDate plusYears(long l) {
        return this.with(this.isoDate.plusYears(l));
    }

    @Override
    ThaiBuddhistDate plusMonths(long l) {
        return this.with(this.isoDate.plusMonths(l));
    }

    @Override
    ThaiBuddhistDate plusWeeks(long l) {
        return (ThaiBuddhistDate)super.plusWeeks(l);
    }

    @Override
    ThaiBuddhistDate plusDays(long l) {
        return this.with(this.isoDate.plusDays(l));
    }

    @Override
    public ThaiBuddhistDate plus(long l, TemporalUnit temporalUnit) {
        return (ThaiBuddhistDate)super.plus(l, temporalUnit);
    }

    @Override
    public ThaiBuddhistDate minus(long l, TemporalUnit temporalUnit) {
        return (ThaiBuddhistDate)super.minus(l, temporalUnit);
    }

    @Override
    ThaiBuddhistDate minusYears(long l) {
        return (ThaiBuddhistDate)super.minusYears(l);
    }

    @Override
    ThaiBuddhistDate minusMonths(long l) {
        return (ThaiBuddhistDate)super.minusMonths(l);
    }

    @Override
    ThaiBuddhistDate minusWeeks(long l) {
        return (ThaiBuddhistDate)super.minusWeeks(l);
    }

    @Override
    ThaiBuddhistDate minusDays(long l) {
        return (ThaiBuddhistDate)super.minusDays(l);
    }

    private ThaiBuddhistDate with(LocalDate localDate) {
        return localDate.equals(this.isoDate) ? this : new ThaiBuddhistDate(localDate);
    }

    public final ChronoLocalDateTime<ThaiBuddhistDate> atTime(LocalTime localTime) {
        return super.atTime(localTime);
    }

    @Override
    public ChronoPeriod until(ChronoLocalDate chronoLocalDate) {
        Period period = this.isoDate.until(chronoLocalDate);
        return this.getChronology().period(period.getYears(), period.getMonths(), period.getDays());
    }

    @Override
    public long toEpochDay() {
        return this.isoDate.toEpochDay();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ThaiBuddhistDate) {
            ThaiBuddhistDate thaiBuddhistDate = (ThaiBuddhistDate)object;
            return this.isoDate.equals(thaiBuddhistDate.isoDate);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getChronology().getId().hashCode() ^ this.isoDate.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    private Object writeReplace() {
        return new Ser(8, this);
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.get(ChronoField.YEAR));
        dataOutput.writeByte(this.get(ChronoField.MONTH_OF_YEAR));
        dataOutput.writeByte(this.get(ChronoField.DAY_OF_MONTH));
    }

    static ThaiBuddhistDate readExternal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        byte by = dataInput.readByte();
        byte by2 = dataInput.readByte();
        return ThaiBuddhistChronology.INSTANCE.date(n, by, by2);
    }
}

