/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpMsg;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduBulk;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduTrap;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import java.util.logging.Level;

public class SnmpMessage
extends SnmpMsg
implements SnmpDefinitions {
    public byte[] community;

    @Override
    public int encodeMessage(byte[] byArray) throws SnmpTooBigException {
        int n = 0;
        if (this.data == null) {
            throw new IllegalArgumentException("Data field is null");
        }
        try {
            BerEncoder berEncoder = new BerEncoder(byArray);
            berEncoder.openSequence();
            berEncoder.putAny(this.data, this.dataLength);
            berEncoder.putOctetString(this.community != null ? this.community : new byte[]{});
            berEncoder.putInteger(this.version);
            berEncoder.closeSequence();
            n = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
        return n;
    }

    @Override
    public int getRequestId(byte[] byArray) throws SnmpStatusException {
        int n = 0;
        BerDecoder berDecoder = null;
        BerDecoder berDecoder2 = null;
        byte[] byArray2 = null;
        try {
            berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            berDecoder.fetchInteger();
            berDecoder.fetchOctetString();
            byArray2 = berDecoder.fetchAny();
            berDecoder2 = new BerDecoder(byArray2);
            int n2 = berDecoder2.getTag();
            berDecoder2.openSequence(n2);
            n = berDecoder2.fetchInteger();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        try {
            berDecoder2.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void decodeMessage(byte[] byArray, int n) throws SnmpStatusException {
        try {
            BerDecoder berDecoder = new BerDecoder(byArray);
            berDecoder.openSequence();
            this.version = berDecoder.fetchInteger();
            this.community = berDecoder.fetchOctetString();
            this.data = berDecoder.fetchAny();
            this.dataLength = this.data.length;
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            throw new SnmpStatusException("Invalid encoding");
        }
    }

    @Override
    public void encodeSnmpPdu(SnmpPdu snmpPdu, int n) throws SnmpStatusException, SnmpTooBigException {
        SnmpPduPacket snmpPduPacket = (SnmpPduPacket)snmpPdu;
        this.version = snmpPduPacket.version;
        this.community = snmpPduPacket.community;
        this.address = snmpPduPacket.address;
        this.port = snmpPduPacket.port;
        this.data = new byte[n];
        try {
            BerEncoder berEncoder = new BerEncoder(this.data);
            berEncoder.openSequence();
            this.encodeVarBindList(berEncoder, snmpPduPacket.varBindList);
            switch (snmpPduPacket.type) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest snmpPduRequest = (SnmpPduRequest)snmpPduPacket;
                    berEncoder.putInteger(snmpPduRequest.errorIndex);
                    berEncoder.putInteger(snmpPduRequest.errorStatus);
                    berEncoder.putInteger(snmpPduRequest.requestId);
                    break;
                }
                case 165: {
                    SnmpPduBulk snmpPduBulk = (SnmpPduBulk)snmpPduPacket;
                    berEncoder.putInteger(snmpPduBulk.maxRepetitions);
                    berEncoder.putInteger(snmpPduBulk.nonRepeaters);
                    berEncoder.putInteger(snmpPduBulk.requestId);
                    break;
                }
                case 164: {
                    SnmpPduTrap snmpPduTrap = (SnmpPduTrap)snmpPduPacket;
                    berEncoder.putInteger(snmpPduTrap.timeStamp, 67);
                    berEncoder.putInteger(snmpPduTrap.specificTrap);
                    berEncoder.putInteger(snmpPduTrap.genericTrap);
                    if (snmpPduTrap.agentAddr != null) {
                        berEncoder.putOctetString(snmpPduTrap.agentAddr.byteValue(), 64);
                    } else {
                        berEncoder.putOctetString(new byte[0], 64);
                    }
                    berEncoder.putOid(snmpPduTrap.enterprise.longValue());
                    break;
                }
                default: {
                    throw new SnmpStatusException("Invalid pdu type " + String.valueOf(snmpPduPacket.type));
                }
            }
            berEncoder.closeSequence(snmpPduPacket.type);
            this.dataLength = berEncoder.trim();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SnmpTooBigException();
        }
    }

    @Override
    public SnmpPdu decodeSnmpPdu() throws SnmpStatusException {
        SnmpPduPacket snmpPduPacket = null;
        BerDecoder berDecoder = new BerDecoder(this.data);
        try {
            int n = berDecoder.getTag();
            berDecoder.openSequence(n);
            switch (n) {
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 166: 
                case 167: 
                case 168: {
                    SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
                    snmpPduRequest.requestId = berDecoder.fetchInteger();
                    snmpPduRequest.errorStatus = berDecoder.fetchInteger();
                    snmpPduRequest.errorIndex = berDecoder.fetchInteger();
                    snmpPduPacket = snmpPduRequest;
                    break;
                }
                case 165: {
                    SnmpPduBulk snmpPduBulk = new SnmpPduBulk();
                    snmpPduBulk.requestId = berDecoder.fetchInteger();
                    snmpPduBulk.nonRepeaters = berDecoder.fetchInteger();
                    snmpPduBulk.maxRepetitions = berDecoder.fetchInteger();
                    snmpPduPacket = snmpPduBulk;
                    break;
                }
                case 164: {
                    SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
                    snmpPduTrap.enterprise = new SnmpOid(berDecoder.fetchOid());
                    byte[] byArray = berDecoder.fetchOctetString(64);
                    snmpPduTrap.agentAddr = byArray.length != 0 ? new SnmpIpAddress(byArray) : null;
                    snmpPduTrap.genericTrap = berDecoder.fetchInteger();
                    snmpPduTrap.specificTrap = berDecoder.fetchInteger();
                    snmpPduTrap.timeStamp = berDecoder.fetchInteger(67);
                    snmpPduPacket = snmpPduTrap;
                    break;
                }
                default: {
                    throw new SnmpStatusException(9);
                }
            }
            snmpPduPacket.type = n;
            snmpPduPacket.varBindList = this.decodeVarBindList(berDecoder);
            berDecoder.closeSequence();
        }
        catch (BerException berException) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpMessage.class.getName(), "decodeSnmpPdu", "BerException", berException);
            }
            throw new SnmpStatusException(9);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_LOGGER.logp(Level.FINEST, SnmpMessage.class.getName(), "decodeSnmpPdu", "IllegalArgumentException", illegalArgumentException);
            }
            throw new SnmpStatusException(9);
        }
        snmpPduPacket.version = this.version;
        snmpPduPacket.community = this.community;
        snmpPduPacket.address = this.address;
        snmpPduPacket.port = this.port;
        return snmpPduPacket;
    }

    @Override
    public String printMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.community == null) {
            stringBuffer.append("Community: null");
        } else {
            stringBuffer.append("Community: {\n");
            stringBuffer.append(SnmpMessage.dumpHexBuffer(this.community, 0, this.community.length));
            stringBuffer.append("\n}\n");
        }
        return stringBuffer.append(super.printMessage()).toString();
    }
}

